// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000
// Procedures for the top secret diary.
//.....................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include <richedit.h>
#include <string.h>
#include <ole2.h>
//#include <ssce.h>
#include "zlib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	UINT				uComDlgHelpMsg;
extern	LPCTSTR				lpszStopSign;
extern	HANDLE				hDlgCurrent;
extern	BOOL				bUseSentrySpellChecker;
extern	TCHAR				szCheckSpellingDlg;
extern	TCHAR				szEditLexDlg;
extern	TCHAR				szOptionsDlg;
extern	TCHAR				szNewLexDlg;
extern	LPCTSTR				lpszExclamation;
extern	DWORD				dwR1;
extern	BOOL				bAa;
extern	BOOL				bSignedIn;
extern	HANDLE				hIdxHandle2;
extern	LPBYTE				lpIndexFile2;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	LPBYTE				lpKeyBufferDup2;
extern	LPBYTE				lpKeyBuffer3;
extern	DWORD				dwIdxOffset2;
extern	BYTE				TempUserId[256];
extern	BYTE				Temp1;
extern	BYTE				Temp9[MAX_MOD_SLOP];
extern	BYTE				Temp6[MAX_MOD_SLOP*2];
extern	BYTE				U_Temp[MAX_MOD_SLOP];
extern	BYTE				D_Temp[MAX_MOD_SLOP];
extern	BYTE				E_Temp[MAX_MOD_SLOP];
extern	BYTE				Prime_P[MAX_PRIME_SLOP];
extern	BYTE				Prime_Q[MAX_PRIME_SLOP];
extern	BYTE				Modulus_N[MAX_MOD_SLOP];
extern	DWORD				dwN_Bytes;
extern	DWORD				dwN_Bits;
extern	UINT				uTimer;
extern	DWORD				dwElapHours;
extern	DWORD				dwElapMinutes;
extern	DWORD				dwElapSeconds;
extern	HWND				hStatusBar;
extern	NONREPRO_HDR		nrphdr;
extern	NONREPRO_PADHDR		nrppadhdr;
extern	BYTE				rphdr[MAX_REPRO_LGTH];
extern	BOOL				bCancelOperation;
extern	HANDLE				hDialogModeLess;
extern	HANDLE				hDlgCurrent;
extern	DWORD				dwCountBytes;
extern	DWORD				dwCountBits;
extern	DWORD				dwReproLength;
extern	LPBYTE				lpCsumOffset;
extern	LPBYTE				lpSeedOffset;
extern	DWORD				dwRngsUsed;
extern	BYTE				RingMask;
extern	DWORD				Seed;
extern	DWORD				TopsArray[256];
extern	DWORD				FactorArray[256];
extern	DWORD				SeedsArray[256];
extern	BYTE				LastSeed;
extern	DWORD				DbleNumber;
extern	DWORD				Divisor1;
extern	SHFILEINFO			shfi1;
extern	HFONT				hDlgFont;
extern	TCHAR				szStatusBarRings[127];
extern	BOOL				bDisplayRingsOnStatusBar;
extern	TCHAR				TimeSep;
extern	TCHAR				szTime[];
extern	DWORD				dwSeedsNeeded;
extern	PARAFORMAT2			pf;
extern	CHARFORMAT2			cf;
extern	BOOL				bNoTextClr;
extern	COLORREF			crSetBkgColor;
extern	COLORREF			crBkgCurrent;
extern	BOOL				bReturnReceipt;
extern	CHOOSECOLOR			crBkg;
extern	CHOOSECOLOR			crText;
extern	BOOL				bChooseBkgColor;
extern	COLORREF			crTextCurrent;
extern	DWORD				dwSpellHelp;
extern	BOOL				bHaveRichEdit3;
extern	LPTSTR				lpFormat[];
extern	LPCTSTR				lpszDiary;
extern	HFONT				hDlgFont;
extern	HFONT				hDlgFont2;
extern	TCHAR				szPkdRtfFile[MAX_PATH];
extern	z_stream			z;
extern	LARGE_INTEGER		liEncFileSize;
extern	LPBYTE				lpInBuffer;
extern  LPBYTE				lpOutBuffer;
extern	MSG_HEADER			Msghdr;
extern	TCHAR				szFileToEncipher[MAX_PATH];
extern	lpMapiMessage		lpmsg;
extern	BOOL				bLoggedOn;
extern	LHANDLE				lHandle;
extern	LPTSTR				lpszNoteText;
extern	ULONG				flSendMsgFlags;
extern	LPTSTR				lpMapiDllName;
extern	LPMAPISENDMAIL		lpfnMAPISendMail;
extern	DWORD				dwCheckCrc32;
extern	LPTSTR				lpszRTF;
extern	LPFINDREPLACE		lpFr;
extern	UINT				uFindMsgString;
extern	TCHAR				szTemp[MAX_PATH];
extern	TCHAR				szTemp1[MAX_PATH];
extern	TCHAR				szTemp2[MAX_PATH];
extern	COLORREF			crOleBkg;
extern	CONFIG				cfg;
extern	HCURSOR				hCursorArrow;
extern	TCHAR				szMyRichEditCtrl[16];
extern	BOOL				bHaveRichEdit41orGreater;

#define BOOKCLOSEDIMAGE		0
#define BOOKOPENIMAGE		1
#define PAGEIMAGE			2
#define MAX_KEYWORD			130

#define MAPISendMail        (*lpfnMAPISendMail)

LPTSTR			lpMonths[13]; // Pointers to the month names for the users locale.
HTREEITEM		hRoot;
HTREEITEM		hByDate;
HTREEITEM		hByKeyword;
HTREEITEM		hPrevYear;
HTREEITEM		hPrevMonth;
HTREEITEM		hPrevItem;
HTREEITEM		hPrevKeyword;
BOOL			bJustCreated;

HIMAGELIST		hDiaryListSmall;
HANDLE			hTreeView;
HICON			hDiaryIcon;

TCHAR			szDateTimeFmt[] = "%s at %s";
TCHAR			szLocalFmt[] = "h':'mm':'ss tt";
TCHAR			szByDate[] = "By Date";
TCHAR			szByKeyword[] = "By Keyword";
TCHAR			szTreeViewControl[] = "Tree View Control";
TCHAR			szDeletePage[] = "Delete";
TCHAR			szCharA[] = "A";
TCHAR			szJrlPassWord[MAX_PATH];
TCHAR			szAAA[MAX_PATH];
UINT			uiBook = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM | TVIF_CHILDREN;
UINT			uiPage = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;

SORT_TEMPLATE	DiarySort = {SORT_WORDS,FORWARD,sizeof(DIARYENTRY),1,38,
							 SORT_STRINGS,FORWARD,sizeof(DIARYENTRY),130,40,
							 SORT_DWORDS,FORWARD,sizeof(DIARYENTRY),2,172,SORT_END};

TCHAR			szMyDiary[MAX_PATH];
TCHAR			szDiaryTemp[MAX_PATH];
TCHAR			szIndexTemp[MAX_PATH];
TCHAR			szDiaryStreamOut[MAX_PATH];
TCHAR			szTempDiary[] = "temp.jrl";
TCHAR			szDiaryName[] = "temp1.jrl";
TCHAR			szIndexName[] = "temp.idx";
TCHAR			szDiaryId[] = "tscj";
TCHAR			szPkdDiaryId[] = "pkdj";
HANDLE			hMyDiary;
HANDLE			hTempDiary;
HANDLE			hIndexTemp;
HANDLE			hDiaryPage;
BOOL			bDiaryModified;
BOOL			bDiaryPageModified;
DWORD			dwPagesDeleted;
BOOL			bDiaryError;
BOOL			bBuildingTree;
BOOL			bMakePermanent;
DWORD			dwIndexEntries;
BOOL			bNewPage;
BOOL			bTempStreamOut;
ULARGE_INTEGER	uliMP;
DWORD			dwPageCount;
DWORD			dwJrlPages;
DWORD			dwJrlKeywords;
DWORD			dwDiaryEndSize;
ULARGE_INTEGER	uliLastDate;
LPBYTE			lpEncSecKey;
TCHAR			szEndA[sizeof(DIARYEND)];
LPSECRETKEYDATA	lpMyKey;
TCHAR			szAdminCode[32];
TCHAR			szPassWord1[MAX_PATH];
TCHAR			szPassWord2[MAX_PATH];

// Structures for the diary.
//..........................
DIARYEND		DiaryEnd;
DIARYPAGE		DiaryPage;
DIARYHDR		DiaryHdr;
DIARYENTRY		DiaryEntry;
DIARYPAGE		NewDiaryPage;
DIARYENTRY		PrevDiaryEntry;

NMTREEVIEW		nmtvCurrent;

LPCTSTR			lpDiary640 = "DIARYPAGE640";
LPCTSTR			lpDiary800 = "DIARYPAGE800";
LPCTSTR			lpDiary1024 = "DIARYPAGE1024";

LPCTSTR			lpDiary640New = "DIARYPAGE640NEW";
LPCTSTR			lpDiary800New = "DIARYPAGE800NEW";
LPCTSTR			lpDiary1024New = "DIARYPAGE1024NEW";

// Event handles.
//...............
HANDLE			hDiaryEvent;
HANDLE			hDiaryOpen;
HHOOK			hMsgFilterHook;

// Open a diary.
//..............
VOID OpenDiary(LPBYTE lpDiary)
{
	OPENFILENAME	ofn;
	LARGE_INTEGER	li;
	LARGE_INTEGER	liWriteTo;
	DWORD			dwOldHelpTopic;
	HANDLE			hRtf = 0;
	HANDLE			hDlgEncrypt = 0;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwRsaIntegerBits;
	DWORD			dwRsaIntegerBytes;
	DWORD			dwCheckSum;
	DWORD			dwHdrCheckSum;
	int				iCompareResult;
	int				iDlgResult;
	int				iResult;
	int				i;
	DWORD			dwResult;
	BOOL			bSignedInOK;
	BOOL			bError;
	DWORD			dwSize;
	DWORD			dwTempEAX;
	TCHAR			szName[MAX_COMPUTERNAME_LENGTH+1];
	TCHAR			szOutBuffer[512];
	DIARYEND		Diary_End;
	LPCTSTR			lpDialogBox;
	ULARGE_INTEGER	uliCurrentTime;
	
	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_OPEN_DIARY);
	hMyDiary = 0;
	hTempDiary = 0;
	hIndexTemp = 0;
	bDiaryModified = FALSE;
	bDiaryPageModified = FALSE;
	dwPagesDeleted = 0;
	bDiaryError = TRUE;
	hDlgCurrent = 0;
	hDialogModeLess = 0;
	hDiaryPage = 0;
	lpEncSecKey = 0;
	dwDiaryEndSize = sizeof(DIARYEND);

	lpMyKey = AllocateMemory(sizeof(SECRETKEYDATA));
	if (!lpMyKey)
	{
		goto EndDiary;
	}
	// Load the rich text edit dll.
	//.............................
	hRtf = LoadLibrary((LPCTSTR)&szMyRichEditCtrl);
	if (!hRtf)
	{
		ErrorProcedure((LPTSTR)&szMyRichEditCtrl,IDS_LOADLIBRARY,MB_OK);
		goto EndDiary;
	}
	// Clear all the variables we will be using.
	//..........................................
	ClearAllVariables();
	ClearMathVariables();

	// Allocate memory for use by the diary procedure.
	//................................................
	lpKeyBuffer1 = AllocateMemory(ENC_BUFFER_SIZE);
	if (!lpKeyBuffer1)
	{
		goto EndDiary;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_DIARYFILES);

	// Get diary if not from command line or a new diary.
	//...................................................
	while(TRUE)
	{
		if (!lpDiary)
		{
			ZeroMemory(&szMyDiary,MAX_PATH);

			ofn.lpstrFile = szMyDiary;	
			ofn.nMaxFile = MAX_PATH;
			ofn.hwndOwner = hMainWindow;
			ofn.lpstrFilter = TEXT("Top Secret Journal Files [.jrl]\0*.jrl\0All Files [*.*]\0*.*\0");
			ofn.nFilterIndex = 1;
			ofn.lpstrTitle = TEXT("Open a Top Secret Journal");
			ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
						 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
						 OFN_SHOWHELP);
			ofn.lpstrDefExt = NULL;
			ofn.lpfnHook = MyOFNHookProc;
		
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto EndDiary;
			}
			SaveDirName((LPBYTE)&szMyDiary,SAVE_SOURCE | SAVE_DIARYFILES,TRUE);
		}
		// Create a backup of the diary in case anything goes wrong.
		//..........................................................
		CopyMemory(&szDiaryTemp,&szMyDiary,MAX_PATH);
		PathRemoveFileSpec((LPTSTR)&szDiaryTemp);
		PathAddBackslash((LPTSTR)&szDiaryTemp);

		// Setup the index file name too.
		//...............................
		CopyMemory(&szIndexTemp,&szDiaryTemp,MAX_PATH);
		StringCbCatEx((LPTSTR)&szIndexTemp,sizeof(szIndexTemp),(LPCTSTR)&szIndexName,NULL,
					   NULL,dwStringSafeFlag);
		StringCbCatEx((LPTSTR)&szDiaryTemp,sizeof(szDiaryTemp),(LPCTSTR)&szTempDiary,
					   NULL,NULL,dwStringSafeFlag);

		bResult = CopyFile((LPCTSTR)&szMyDiary,(LPCTSTR)&szDiaryTemp,FALSE);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_COPYFILE,MB_OK);
			goto EndDiary;
		}
		// Open the file and make sure it has a valid header.
		//...................................................
		hMyDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,0,
								 NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hMyDiary)
		{
			goto EndDiary;
		}
		bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryHdr,sizeof(DiaryHdr),
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto EndDiary;
		}
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&DiaryHdr,
									   sizeof(DiaryHdr),(LPCTSTR)&szDiaryId,dwBytesRead);
		if (iCompareResult == CSTR_EQUAL)
		{
			// Read in the DIARYEND structure and check it out.
			//.................................................
			li.QuadPart = 0;
			li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_END);
			if (li.QuadPart == -1)
			{
				goto EndDiary;
			}
			li.QuadPart -= sizeof(DIARYEND);
			if (li.QuadPart < sizeof(DIARYHDR))
			{
				SetLastError(IDS_INVALIDDIARY);
				ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			}
			else
			{
				break;
			}
		}
		else
		{
			// Not a valid diary file.
			//........................
			SetLastError(IDS_INVALIDDIARY);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		}
		bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
		if (!bResult)
		{
			goto EndDiary;
		}
		hMyDiary = 0;
		lpDiary = NULL;
	}
	// Read in the DIARYEND structure.
	//................................
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto EndDiary;
	}
	bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryEnd,sizeof(DIARYEND),
						  &dwBytesRead,NULL);
	if (!bResult)
	{
		goto EndDiary;
	}
	while(TRUE)
	{
		EmptyTheMessageQue();

		// If the diary was not just created we have to get the password.
		//...............................................................
		if (!bJustCreated)
		{
			// Get the password, if required, to decrypt the DIARYEND structure.
			// If we just created it, we alread have it.
			//..................................................................
			iDlgResult = DialogBox(hInst,TEXT("DIARYSIGNIN"),hMainWindow,
								  (DLGPROC)DiarySignInProc);
			if (iDlgResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto EndDiary;
			}
			if (iDlgResult == IDCANCEL)
			{
				bDiaryError = FALSE;
				goto EndDiary;
			}
		}
		CopyMemory(&Diary_End,&DiaryEnd,sizeof(DIARYEND));
		bJustCreated = FALSE;

		// We have the password.
		//......................
		DecipherSecretComponents((LPBYTE)&szJrlPassWord,(LPBYTE)&Diary_End.id,
								  lstrlen((LPCTSTR)&szJrlPassWord),sizeof(DIARYEND)-CFB_LENGTH);

		// See if the id field is equal to tscd.
		//......................................
		iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Diary_End.id,4,
							   (LPCTSTR)&szDiaryId,4);

		if (iResult != CSTR_EQUAL)
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNINDIARY,
						   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
						   MB_ICONEXCLAMATION,0);
			continue;
		}
		CopyMemory(&DiaryEnd,&Diary_End,sizeof(DIARYEND));
		ZeroMemory(&Diary_End,sizeof(DIARYEND));
		break;
	}
	// Hide the password to our journal.
	//..................................
	GetRandomBits(8 * MAX_PATH,&szAAA);
	
	__asm
	{
		mov		esi,offset szAAA
		mov		edi,offset szJrlPassWord
		mov		ecx,MAX_PATH
	L1:	lodsb
		xor		byte ptr [edi],al
		not		byte ptr [edi]
		inc		edi
		dec		ecx
		jnz		L1
	}
	// Setup the pages and keywords variables and the last date.
	//..........................................................
	dwJrlPages = DiaryEnd.dwPages;
	dwJrlKeywords = DiaryEnd.dwKeywords;
	uliLastDate.QuadPart = DiaryEnd.uliDate.QuadPart;

	// If this diary requires an admin account check out the details to make sure
	// we can run it on this computer.
	//...........................................................................
	if (DiaryEnd.bAdmin)
	{
		if (!bAa)
		{
		  InvalidDiary:
			SetLastError(IDS_NOADMINDIARY);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
		if (bAa && dwR1 != 1)
		{
			SetLastError(IDS_NOTRIALDIARY);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
		bMakePermanent = FALSE;

		// We have a valid admin account. Check out the computer name.
		//............................................................
		dwSize = sizeof(szName);
		bResult = GetComputerName((LPTSTR)&szName,&dwSize);
		if (!bResult)
		{
			goto InvalidDiary;
		}
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szName,-1,
									   (LPCTSTR)&DiaryEnd.szName,-1);
		if (iCompareResult != CSTR_EQUAL)
		{
			// If the administrator is not signed in, do so now.
			//..................................................
			if (!bSignedIn)
			{
				// Sign in to your admin account.
				//...............................
				bSignedInOK = AdminSignIn(FALSE);
				bProcessInProgress = TRUE;

				if (!bSignedInOK)
				{
					goto EndDiary;
				}
			}
			// Ask the administrator if it is OK to view on this computer.
			//............................................................
			iDlgResult = DialogBox(hInst,TEXT("ADMINCODESIGNIN"),hMainWindow,
								  (DLGPROC)AdminCodeSignInProc);
			if (iDlgResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto EndDiary;
			}
			if (iDlgResult == IDCANCEL)
			{
				bDiaryError = FALSE;
				goto EndDiary;
			}
			if (bMakePermanent)
			{
				CopyMemory(&DiaryEnd.szName,&szName,sizeof(szName));
			}
		}
	}
	else
	{
		if (bAa)
		{	
			// If the diary was created under a single user license and
			// we have an admin account, bail out.
			//.........................................................
			SetLastError(IDS_NOTSINGLEUSER);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
	}
	// Make sure that the current date is the same or greater than the last one.
	//..........................................................................
	uliCurrentTime.QuadPart = GetTimestamp(FALSE);

	if (uliCurrentTime.QuadPart < DiaryEnd.uliDate.QuadPart)
	{
		SetLastError(IDS_DIARYDATEINVALID);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto EndDiary;
	}
	// Set the end of file to get rid of the DIARYEND structure.
	// Makes it easier to append new pages.
	//..........................................................
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto EndDiary;
	}
	bResult = SetEndOfFile(hMyDiary);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_SETENDOFFILE,MB_OK);
		goto EndDiary;
	}
	bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	if (!bResult)
	{
		goto EndDiary;
	}
	hMyDiary = 0;
	bDiaryModified = TRUE;

	// Open the diary file again.
	//...........................
	hMyDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,0,
						     NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hMyDiary)
	{
		goto EndDiary;
	}
	// Decrypt the pke packet.
	//........................
	dwRsaIntegerBits = (WORD)DiaryEnd.PkeHdr.MPI_PREFIX;

	__asm
	{
		mov		eax,dwRsaIntegerBits
		xchg	ah,al
		mov		dwRsaIntegerBits,eax
		add		eax,7
		shr		eax,3
		mov		dwRsaIntegerBytes,eax
	}
	// If this is not a RSA key bail out.
	//...................................
	if (DiaryEnd.PkeHdr.RSA_ALGOR != RSA_ALGORITHM || 
		DiaryEnd.PkeHdr.VERSION > VERSION_NEW || dwRsaIntegerBits > MAX_BITS)
	{
		SetLastError(IDS_DIARYKEYNOGOOD);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto EndDiary;
	}
	// We have to decrypt the file and setup the various tables for the tree control.
	// First check to make sure we have the keys required.
	//...............................................................................
	bError = SetupDiaryKey((LPBYTE)&DiaryEnd.PkeHdr.KEY_ID);
	if (bError)
	{
		goto EndDiary;
	}
	// We now have all the key components. We can now decipher the public
	// key encrypted packet if we have anything to decrypt. A diary without
	// any records will not have a public key encrypted packet.
	//.....................................................................
	if (DiaryEnd.dwPages)
	{
		CopyMemory(&Temp9,&DiaryEnd.Pke,dwRsaIntegerBytes);
		CircleSwap((LPBYTE)&Temp9,dwRsaIntegerBytes);

		// The number of bits in the rsa integer must be less than
		// or equal to the number of bits in modulus n in the 
		// Secret Key.
		//........................................................
		if (dwRsaIntegerBits > lpMyKey->dwN_Bits)
		{
		  InvalidRsaInteger:
			SetLastError(IDS_RSAINTEGERGTEMODULUSN);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
		// If the number of bits are equal, do an actual comparision to
		// make sure the rsa integer is less than modulus n.
		//.............................................................
		if (dwRsaIntegerBits == lpMyKey->dwN_Bits)
		{
			dwResult = MpCompareDW((LPBYTE)lpMyKey->Modulus_N,(LPBYTE)&Temp9,MAX_MOD_DWORD);
			if (dwResult ==	0 || dwResult == 1)
			{
				goto InvalidRsaInteger;
			}
		}
		// Setup our elapsed timer.
		//.........................
		dwElapHours = 0;
		dwElapMinutes = 0;
		dwElapSeconds = 0;
		uTimer = SetTimer(hMainWindow,MY_TIMER,1000,(TIMERPROC)My1SecondTimer);

		DisplayZeroTimer();
		EmptyTheMessageQue();

		// Decrypt our pke packet.
		//........................
		bCancelOperation = FALSE;
		hDialogModeLess = CreateDialog(hInst,TEXT("DECRYPTPKEPACKETDIARY"),hMainWindow,
									  (DLGPROC)DecryptPkePacketDiaryProc);

		if (!hDialogModeLess)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto EndDiary;
		}
		bError = RsaPriDec((LPBYTE)&Temp6,(LPBYTE)&Temp9,(LPBYTE)lpMyKey->D_Temp,
						   (LPBYTE)lpMyKey->Prime_P,(LPBYTE)lpMyKey->Prime_Q,
						   (LPBYTE)lpMyKey->U_Temp,lpMyKey->dwN_Bytes);

		EmptyTheMessageQue();

		if (bCancelOperation == TRUE)
		{
			goto EndDiary;
		}
		// Check to see if we had an error.
		//.................................
		if (bError)
		{
			SetLastError(IDS_RSAPRIVATEDECRYPTERROR);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
		// Setup the random key to decipher the diary file.
		//.................................................
		if (dwCountBytes == KEY_4_LGTH || dwCountBytes == KEY_8_LGTH ||
			dwCountBytes == KEY_16_LGTH || dwCountBytes == KEY_32_LGTH ||
			dwCountBytes == KEY_64_LGTH || dwCountBytes == KEY_128_LGTH)
		{
			dwReproLength = dwCountBytes;
			CopyMemory(&rphdr,&Temp6,dwCountBytes);
		}
		else
		{
			// We have a key length we cannot deal with.
			//..........................................
			SetLastError(IDS_INVALIDKEYLENGTH);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
		// Check out the checksum to make sure it is correct.
		//...................................................
		lpCsumOffset = (LPBYTE)&rphdr;
		lpSeedOffset = (LPBYTE)&rphdr;

		dwRngsUsed = RNGS_128;

		if (dwReproLength == KEY_4_LGTH)
		{
			dwRngsUsed = RNGS_4;
		}
		else if (dwReproLength == KEY_8_LGTH)
		{
			dwRngsUsed = RNGS_8;
		}
		else if (dwReproLength == KEY_16_LGTH)
		{
			dwRngsUsed = RNGS_16;
		}
		else if (dwReproLength == KEY_32_LGTH)
		{
			dwRngsUsed = RNGS_32;
		}
		else if (dwReproLength == KEY_64_LGTH)
		{
			dwRngsUsed = RNGS_64;
		}
		lpCsumOffset += (dwReproLength - SIZE_OF_CSUM);
		lpSeedOffset += (dwReproLength - SIZE_OF_CSUM - SIZE_OF_SEED);

		__asm
		{
			mov		eax,dwRngsUsed
			mov		RingMask,al
			dec		RingMask
		}
		// Calculate and check the checksum of the header.
		//................................................
		__asm
		{
			mov		esi,lpCsumOffset
			movzx	eax,word ptr [esi]
			xchg	ah,al
			mov		dwHdrCheckSum,eax
		}
		dwCheckSum = CheckSum((LPBYTE)&rphdr,(dwReproLength - SIZE_OF_CSUM));
		if (dwHdrCheckSum != dwCheckSum)
		{
			SetLastError(IDS_PKECSUMINVALID);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto EndDiary;
		}
		__asm
		{
			mov		esi,lpSeedOffset
			mov		eax,dword ptr [edi]
			mov		Seed,eax
		}
		// Setup the random number generators.
		// Setup the factor array first, followed by the tops and
		// seeds arrays.
		//.......................................................
		__asm
		{
			mov		eax,dwRngsUsed
			mov		ecx,SIZE_OF_SEED
			mul		ecx
			mov		ecx,eax
			push	ecx
			push	ecx
			mov		esi,offset rphdr
			mov		edi,offset FactorArray
			rep		movsb
			pop		ecx
			mov		edi,offset TopsArray
			rep		movsb
			pop		ecx
			mov		edi,offset SeedsArray
			rep		movsb

			// Setup the first LastSeed value.
			//................................
			mov		al,byte ptr rphdr[12]
			and		al,RingMask
			mov		LastSeed,al

			// Setup the DbleNumber value.
			//............................
			mov		esi,lpSeedOffset
			mov		eax,dword ptr [esi-7]
			clc
			rcl		eax,1
			jnc		L2
			mov		eax,-1
	   L2:	mov		DbleNumber,eax
		}
		ZeroMemory(&rphdr,MAX_REPRO_LGTH);
		Divisor1 = 256;

		// Now decrypt the diary. It starts at the end of the diary header.
		//.................................................................
		liWriteTo.QuadPart = sizeof(DIARYHDR);
		liWriteTo.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,liWriteTo.QuadPart,
											   FILE_BEGIN);
		if (liWriteTo.QuadPart == -1)
		{
			goto EndDiary;
		}
		bCancelOperation = FALSE;

		LoadString(hInst,IDS_DECRYPTINGDIARY,szOutBuffer,sizeof(szOutBuffer));
		SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szOutBuffer);

		// Decrypt the diary.
		//...................
		while(TRUE)
		{
			EmptyTheMessageQue();

			bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,lpKeyBuffer1,ENC_BUFFER_SIZE,
								 &dwBytesRead,NULL);
			if (!bResult)
			{
				goto EndDiary;
			}
			// Check for end of file.
			//.......................
			if (dwBytesRead == 0)
			{
				break;
			}
			ChangeBytes(lpKeyBuffer1,dwBytesRead);

			liWriteTo.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,
												   liWriteTo.QuadPart,FILE_BEGIN);
			if (liWriteTo.QuadPart == -1)
			{
				goto EndDiary;
			}
			bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,lpKeyBuffer1,dwBytesRead,
								   &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto EndDiary;
			}
			liWriteTo.QuadPart += dwBytesWritten;
		}
	}
	// Clear all the variables used.
	//..............................
	ClearAllVariables();
	ClearMathVariables();

	// Encipher the secret key components in memory.
	//..............................................
	bResult = EncComponents();

	if (!bResult)
	{
		goto EndDiary;
	}
	// Create the Index file for the diary.
	//.....................................
	hIndexTemp = CreateMyFile((LPTSTR)&szIndexTemp,GENERIC_READ | GENERIC_WRITE,0,
							   NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hIndexTemp)
	{
		goto EndDiary;
	}

	if (DiaryEnd.dwPages)
	{
		if (hDialogModeLess)
		{
			LoadString(hInst,IDS_DIARYINDEXFILE,szOutBuffer,sizeof(szOutBuffer));
			SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szOutBuffer);
		}
		bError = CreateDiaryIndexFile();
		if (bError)
		{
			goto EndDiary;
		}
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	EmptyTheMessageQue();

	// We are done decrypting the diary. Turn off the timer and reset
	// the status bar.
	//...............................................................
	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Reset the status bar to ready or the name of the key rings.
	//............................................................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,szOutBuffer,sizeof(szOutBuffer));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szOutBuffer);
	}
	// Display the diary dialog box and fill the tree index.
	//......................................................
	EmptyTheMessageQue();

	// Create a hook procedure to capture messages for a dialog box.
	//..............................................................
	hMsgFilterHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapDlgMsgInput,NULL,0);

	// Create an event for our diary page dialog box.
	//...............................................
	hDiaryEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("DiaryEvent"));
	if (!hDiaryEvent)
	{
		ErrorProcedure(TEXT("DiaryEvent"),IDS_CREATEEVENT,MB_OK);
		goto EndDiary;
	}
	// Get the current screen size so we can display the correct
	// dialog box.
	//..........................................................
	i = GetSystemMetrics(SM_CXFULLSCREEN);
			
	if (bHaveRichEdit41orGreater)
	{
		if (i >= 950)
		{
			lpDialogBox = lpDiary1024New;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpDiary800New;
		}
		else
		{
			lpDialogBox = lpDiary640New;
		}
	}
	else
	{
		if (i >= 950)
		{
			lpDialogBox = lpDiary1024;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpDiary800;
		}
		else
		{
			lpDialogBox = lpDiary640;
		}
	}
	// Create the dialog box.
	//.......................
	hDiaryPage = CreateDialog(hInst,lpDialogBox,hMainWindow,(DLGPROC)DiaryPageProc);

	if (hDiaryPage == NULL)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto EndDiary;
	}
	EmptyTheMessageQue();

	// Open our event and wait.
	//.........................
	hDiaryOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("DiaryEvent"));
	if (!hDiaryOpen)
	{
		DestroyWindow(hDiaryPage);
		goto EndDiary;
	}
	// Encrypt the DIARYEND header. We do not need it until we finish.
	//................................................................
	GetRandomBits(8 * (sizeof(DIARYEND)),&szEndA);

	__asm
	{
		mov		esi,offset szEndA
		mov		edi,offset DiaryEnd
		mov		ecx,dwDiaryEndSize
	L4:	lodsb
		xor		byte ptr [edi],al
		not		byte ptr [edi]
		inc		edi
		dec		ecx
		jnz		L4
	}
	// We have to wait for the Edit Event to become signaled before
	// we can return and quit.
	//.............................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hDiaryEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}
	hTreeView = 0;

	EmptyTheMessageQue();

	if (hDiaryOpen)
	{
		CloseHandle(hDiaryOpen);
		hDiaryOpen = 0;
	}
	if (hDiaryEvent)
	{
		CloseHandle(hDiaryEvent);
		hDiaryEvent = 0;
	}
	EmptyTheMessageQue();

	// Decrypt the DIARYEND header.
	//.............................
	__asm
	{
		mov		esi,offset szEndA
		mov		edi,offset DiaryEnd
		mov		ecx,dwDiaryEndSize
	L5:	lodsb
		xor		byte ptr [edi],al
		not		byte ptr [edi]
		inc		edi
		dec		ecx
		jnz		L5
	}
	DiaryEnd.dwKeywords = dwJrlKeywords;
	DiaryEnd.dwPages = dwJrlPages;
	DiaryEnd.uliDate.QuadPart = uliLastDate.QuadPart;

	// We are done with the diary. Encrypt the diary file and the pke packet.
	//.......................................................................
	if (DiaryEnd.dwPages)
	{
		hDlgEncrypt = CreateDialog(hInst,TEXT("ENCRYPTDIARY"),hMainWindow,
								  (DLGPROC)CenterDlgBoxProc);
		if (!hDlgEncrypt)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto EndDiary;
		}
		// Clear all the variables we will be using.
		//..........................................
		ClearAllVariables();
		ClearMathVariables();

		if (dwPagesDeleted > 0)
		{
			bDiaryPageModified = TRUE;
		}
		// If the diary was modified, i.e. a page modified, delete the old page.
		//......................................................................
		if (bDiaryPageModified)
		{
			bError = DeleteOldDiaryPages();
			if (bError)
			{
				goto EndDiary;
			}
		}
		// Decipher the secret key components.
		//....................................
		DecComponents();

		// Setup the random number generators.
		//....................................
		SetupDiaryRngs(lpMyKey->dwN_Bytes);

		RsaPubEnc(&Temp1,(LPBYTE)&rphdr,dwReproLength,(LPBYTE)lpMyKey->E_Temp,
			     (LPBYTE)lpMyKey->Modulus_N,lpMyKey->dwN_Bytes);
		if (bCancelOperation == TRUE)
		{
			goto EndDiary;
		}
		__asm
		{
			mov		eax,dwCountBits
			xchg	ah,al
			mov		DiaryEnd.PkeHdr.MPI_PREFIX,ax
		}
		dwTempEAX = (dwCountBytes + sizeof(PKEY_HDR) -3);

		__asm
		{
			mov		eax,dwTempEAX
			xchg	ah,al
			mov		DiaryEnd.PkeHdr.LENGTH,ax
		}
		CircleSwap((LPBYTE)&Temp1,dwCountBytes);

		// Copy the pke packet to the DIARYEND header.
		//............................................
		CopyMemory(&DiaryEnd.Pke,&Temp1,dwCountBytes);

		// Setup the arrays for encrypting the diary file.
		//................................................
		SetupDiaryArrays();
		Divisor1 = 256;

		li.QuadPart = sizeof(DIARYHDR);
		li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto EndDiary;
		}
		// Loop through the file and encrypt it.
		//......................................
		while(TRUE)
		{
			bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,lpKeyBuffer1,ENC_BUFFER_SIZE,
								 &dwBytesRead,NULL);
			if (!bResult)
			{
				goto EndDiary;
			}
			if (dwBytesRead == 0)
			{
				break;
			}
			ChangeBytes(lpKeyBuffer1,dwBytesRead);

			// Set the file pointer back to the start of the read.
			//....................................................
			li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,
										   FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				goto EndDiary;
			}
			bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,lpKeyBuffer1,dwBytesRead,
								   &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto EndDiary;
			}
			li.QuadPart += dwBytesWritten;
		}
	}
	// We have finished with the diary. Write the DIARYEND header to the
	// end of the file. The diary is encrypted and the DIARYEND header
	// all set.
	//...................................................................
	if (!hMyDiary)
	{
		hMyDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,0,
								 NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hMyDiary)
		{
			goto EndDiary;
		}
	}
	// Set the file pointer to the end of file.
	//.........................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_END);
	if (li.QuadPart == -1)
	{
		goto EndDiary;
	}
	// Decrypt the password for the journal.
	//......................................
	__asm
	{
		mov		esi,offset szAAA
		mov		edi,offset szJrlPassWord
		mov		ecx,MAX_PATH
	L3:	lodsb
		xor		byte ptr [edi],al
		not		byte ptr [edi]
		inc		edi
		dec		ecx
		jnz		L3
	}
	// Encrypt the DIARYEND header with the password.
	//...............................................
	GetRandomBits((CFB_LENGTH*8),&DiaryEnd.cfb);
	EncipherSecretComponents((LPBYTE)&szJrlPassWord,(LPBYTE)&DiaryEnd.id,
							  lstrlen((LPCTSTR)&szJrlPassWord),sizeof(DIARYEND)-CFB_LENGTH);

	bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryEnd,sizeof(DiaryEnd),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto EndDiary;
	}
	bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	if (!bResult)
	{
		goto EndDiary;
	}
	hMyDiary = 0;
	bDiaryError = FALSE;
	bDiaryModified = FALSE;

	EndDiary:

	ClearAllVariables();
	ClearMathVariables();

	ZeroMemory(&DiaryEnd,sizeof(DIARYEND));
	ZeroMemory(&DiaryPage,sizeof(DIARYPAGE));
	ZeroMemory(&NewDiaryPage,sizeof(DIARYPAGE));
	ZeroMemory(&szJrlPassWord,MAX_PATH);
	ZeroMemory(&DiaryEntry,sizeof(DIARYENTRY));
	ZeroMemory(&PrevDiaryEntry,sizeof(DIARYENTRY));

	if (lpMyKey)
	{
		ZeroMemory(lpMyKey,sizeof(SECRETKEYDATA));
		DeallocateMemory(lpMyKey);
	}
	if (lpEncSecKey)
	{
		ZeroMemory(lpEncSecKey,sizeof(SECRETKEYDATA));
		DeallocateMemory(lpEncSecKey);
		lpEncSecKey = 0;
	}
	if (hMsgFilterHook)
	{
		UnhookWindowsHookEx(hMsgFilterHook);
		hMsgFilterHook = 0;
	}
	if (hDiaryOpen)
	{
		CloseHandle(hDiaryOpen);
		hDiaryOpen = 0;
	}
	if (hDiaryEvent)
	{
		CloseHandle(hDiaryEvent);
		hDiaryEvent = 0;
	}
	if (hRtf)
	{
		FreeLibrary(hRtf);
	}
	// Destroy the modless dialog box.
	//................................
	if (hDlgEncrypt)
	{
		DestroyWindow(hDlgEncrypt);
	}
	EmptyTheMessageQue();

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Reset the status bar to ready or the name of the key rings.
	//............................................................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,szOutBuffer,sizeof(szOutBuffer));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szOutBuffer);
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,ENC_BUFFER_SIZE);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (hMyDiary)
	{
		CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	}
	if (bDiaryModified && bDiaryError)
	{
		// Wipe the original journal which may be decrypted.
		//..................................................
		WipeMyFile((LPTSTR)&szMyDiary,TRUE);

		// We have to replace the diary with the copy.
		//............................................
		bResult = CopyFile((LPCTSTR)&szDiaryTemp,(LPCTSTR)&szMyDiary,FALSE);
		if (bResult)
		{
			WipeMyFile((LPTSTR)&szDiaryTemp,TRUE);
		}
	}
	else if (!bDiaryError && !bDiaryModified)
	{
		WipeMyFile((LPBYTE)&szDiaryTemp,TRUE);
	}
	if (hIndexTemp)
	{
		CloseMyHandle((LPTSTR)&szIndexTemp,hIndexTemp);
		WipeMyFile((LPBYTE)&szIndexTemp,TRUE);
	}
	
	ChangeHelpTopic(dwOldHelpTopic);
	bJustCreated = FALSE;
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}

// Trap messages to dialog boxes to trap the enter key for our treeview control.
//..............................................................................
LRESULT CALLBACK TrapDlgMsgInput(int nCode, WPARAM wParam, LPARAM lParam)
{
	LPMSG		lpMsg;
	TVITEMEX	tviex;
	
	lpMsg = (LPVOID)lParam;

	if (nCode == MSGF_DIALOGBOX && lpMsg->hwnd == hTreeView && 
		lpMsg->message == WM_KEYDOWN && lpMsg->wParam == VK_RETURN)
	{
		// If this is a parent item, toggle its state.
		//............................................
		if (nmtvCurrent.itemNew.lParam == -1)
		{
			tviex.mask = TVIF_STATE;
			tviex.hItem = nmtvCurrent.itemNew.hItem;

			TreeView_GetItem(hTreeView,&tviex);
			
			if (tviex.state & TVIS_EXPANDED)
			{
				tviex.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_HANDLE;
				tviex.iImage = BOOKCLOSEDIMAGE;
				tviex.iSelectedImage = BOOKCLOSEDIMAGE;
				tviex.hItem = nmtvCurrent.itemNew.hItem;
				TreeView_SetItem(hTreeView,&tviex);
			}
			else
			{
				tviex.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_HANDLE;
				tviex.iImage = BOOKOPENIMAGE;
				tviex.iSelectedImage = BOOKOPENIMAGE;
				tviex.hItem = nmtvCurrent.itemNew.hItem;
				TreeView_SetItem(hTreeView,&tviex);
			}
			TreeView_Expand(hTreeView,nmtvCurrent.itemNew.hItem,TVE_TOGGLE);
			EmptyTheMessageQue();
		}
		else
		{
			// A child item. Display the diary page.
			//......................................
			DisplayDiaryPage(hDlgCurrent,&nmtvCurrent);
		}
		return(1);
	}
	else
	{
		return(CallNextHookEx(hMsgFilterHook,nCode,wParam,lParam));
	}
}

// CALLBACK procedure for the diary page.
//.......................................
LRESULT CALLBACK DiaryPageProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL				bError;
    LONG				cb;
	LONG				cLines;
	BOOL				bResult;
	int					iDlgResult;
	DWORD				dwBytesWritten;
	UINT				uCheck;
	CHARRANGE			cr;
	HICON				hIcon;
	WORD				wIcon;
	int					i;
	ULONG				ulResult;
	
	cf.cbSize = sizeof(CHARFORMAT2);
	pf.cbSize = sizeof(PARAFORMAT2);

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszDiary;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_STATEMENT1,IDC_QUESTION1);
			SetBoldFont2(hDlg,IDC_MARK);

			// Get the handle to the tree view contorl.
			//.........................................
			hTreeView = GetDlgItem(hDlg,IDC_DIARYTREE);

			// Create the image list for the tree view control.
			//.................................................
			hDiaryListSmall = ImageList_Create(16,16,ILC_MASK,TREE_ICONS_MAX,0);
			
			if (hDiaryListSmall)
			{
				// Load the icons to use for the messages.
				//........................................
				wIcon = TREE_ICONS_BASE;

				for (i = 0; i < TREE_ICONS_MAX; i++)
				{
					hIcon = LoadImage(hInst,MAKEINTRESOURCE(wIcon),IMAGE_ICON,16,16,LR_VGACOLOR);
					ImageList_AddIcon(hDiaryListSmall,hIcon);
					DestroyIcon(hIcon);
					wIcon++;
				}
				TreeView_SetImageList(hTreeView,hDiaryListSmall,TVSIL_NORMAL );
			}
			// This is always a new page.
			//...........................
			bNewPage = TRUE;

			// Disable the new page button.
			//.............................
			EnableWindow(GetDlgItem(hDlg,IDC_NEWPAGE),FALSE);
			EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),FALSE);
			EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),FALSE);

			ZeroMemory(&NewDiaryPage,sizeof(DIARYPAGE));
			CopyMemory(&NewDiaryPage.id,&szDiaryId,4);
			ZeroMemory(&PrevDiaryEntry,sizeof(DIARYENTRY));

			// Set the 48 by 48 icon image.
			//.............................
			hDiaryIcon = LoadImage(hInst,"ATSC_APP",IMAGE_ICON,48,48,0);
			if (hDiaryIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hDiaryIcon,0);
			}
			// Set the local date and time for date created.
			//..............................................
			SetLocalDateTime(hDlg);

			// The text color button is disabled on entry.
			//............................................
			bNoTextClr = TRUE;

			// If we did not initialize the spell checker, gray its button.
			//.............................................................
			if (!bUseSentrySpellChecker)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_SPELLCHECK),FALSE);
			}
			// Set the limit on the keywords to 130 bytes.
			//............................................
			SendDlgItemMessage(hDlg,IDC_KW1,EM_SETLIMITTEXT,(WPARAM) 130,0);
			SendDlgItemMessage(hDlg,IDC_KW2,EM_SETLIMITTEXT,(WPARAM) 130,0);
			SendDlgItemMessage(hDlg,IDC_KW3,EM_SETLIMITTEXT,(WPARAM) 130,0);
			SendDlgItemMessage(hDlg,IDC_KW4,EM_SETLIMITTEXT,(WPARAM) 130,0);
			SendDlgItemMessage(hDlg,IDC_KW5,EM_SETLIMITTEXT,(WPARAM) 130,0);
			SendDlgItemMessage(hDlg,IDC_KW6,EM_SETLIMITTEXT,(WPARAM) 130,0);

			// Setup the rich text edit control.
			//..................................
			SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_EXLIMITTEXT,0,FIVEMEGABYTES);

			// Setup event notification.
			//..........................
			SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETEVENTMASK,0,
							  (LPARAM)ENM_KEYEVENTS | ENM_MOUSEEVENTS | ENM_LINK);

			// Make sure the old background color is saved in case we
			// respond to a message before composing one.
			//.......................................................
			crSetBkgColor = cfg.diarycf.crBackColor;

			// Setup ole callback.
			//....................
			SetupOleCallback(hDlg,IDC_DIARYNOTE);

			// Lets setup the character formating.
			//....................................
			cf.cbSize = sizeof(CHARFORMAT2);
			if (!cfg.diarycf.cbSize)
			{
				SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETCHARFORMAT,0,(LPARAM)&cf);
				CopyMemory(&cfg.diarycf,&cf,sizeof(CHARFORMAT2));
				crOleBkg = GetSysColor(COLOR_WINDOW);
				cfg.diarycf.crBackColor = crOleBkg;
			}
			else
			{
				CopyMemory(&cf,&cfg.diarycf,sizeof(CHARFORMAT2));
				SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETBKGNDCOLOR,0,
								  (LPARAM)(COLORREF)cf.crBackColor);
				crBkgCurrent = cf.crBackColor;
				crSetBkgColor = cf.crBackColor;
				crOleBkg = cf.crBackColor;
				EnableWindow(GetDlgItem(hDlg,IDC_TEXTCLR),TRUE);
				bNoTextClr = FALSE;
			}
			SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_ALL,(LPARAM)&cf);

			// Setup the initial paragraph alignment depending on what is set.
			//................................................................
			pf.cbSize = sizeof(PARAFORMAT2);
			SendMessage(GetDlgItem(hDlg,IDC_DIARYNOTE),EM_GETPARAFORMAT,0,(LPARAM)&pf);
			SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);

			// Set the return request radiobutton as appropriate.
			//...................................................
			if (bReturnReceipt)
			{
				CheckDlgButton(hDlg,IDC_RETURN,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_RETURN,BST_UNCHECKED);
			}
			// Create the tree view control.
			//..............................
			bError = CreateTreeView();
			if (bError)
			{
				EndDialog(hDlg,IDCANCEL);
			}
			// Update the radio buttons.
			//..........................
			UpdateRtfRadioButtons(hDlg,IDC_DIARYNOTE);

			SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));

			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return FALSE;
		}

		case WM_NOTIFY:
		{
			LPENLINK		pEnlink;
			LPNMHDR			lpNmhdr;
			LPMSGFILTER		lpMsgFilter;
			LPNMTREEVIEW	lptv;
			LPBYTE			lpLink;
			DWORD			dwLinkSize;
			CHARRANGE		range;
			LPNMTVKEYDOWN	tvKey;

			pEnlink = (LPENLINK)lParam;
			lpNmhdr = (LPNMHDR)lParam;
			lpMsgFilter = (LPMSGFILTER)lParam;
			lptv = (LPNMTREEVIEW)lParam;
			tvKey = (LPNMTVKEYDOWN)lParam;

			switch(lpNmhdr->code) 
			{
				case EN_MSGFILTER:
				{
					if (lpNmhdr->idFrom == IDC_DIARYNOTE)
					{
						if (lpMsgFilter->msg == WM_LBUTTONUP || lpMsgFilter->msg == WM_KEYUP)
						{
							UpdateRtfRadioButtons(hDlg,lpNmhdr->idFrom);
						}
					}
				}
				break;

				case NM_CLICK:
				case NM_RCLICK:
				{
					if (bBuildingTree)
					{
						return(TRUE);
					}
					else
					{
						return(FALSE);
					}
				}
				break;

				case NM_DBLCLK:
				case NM_RDBLCLK:
				{
					return(TRUE);
				}
				break;

				case NM_SETCURSOR:
				{
					if (bBuildingTree)
					{
						return(FALSE);
					}
					else
					{
						return(TRUE);
					}
				}
				break;

				case EN_LINK:
				{
					if (pEnlink->msg == WM_LBUTTONUP)
					{
						// Get the range and allocate the buffer.
						//.......................................
						dwLinkSize = pEnlink->chrg.cpMax - pEnlink->chrg.cpMin;
						if (dwLinkSize)
						{
							lpLink = AllocateMemory(dwLinkSize + 10);
							if (lpLink)
							{
								SetCursor(hCursorArrow);
								range.cpMax = pEnlink->chrg.cpMax;
								range.cpMin = pEnlink->chrg.cpMin;

								SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_EXSETSEL,0,
												  (LPARAM)(CHARRANGE FAR *)&range);
								SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETSELTEXT,0,
												  (LPARAM)lpLink);
								ShellExecute(NULL,"open",(LPCTSTR)lpLink,NULL,NULL,
											 SW_SHOWNORMAL);
								range.cpMin = -1;
								SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_EXSETSEL,0,
												  (LPARAM)(CHARRANGE FAR *)&range);
								DeallocateMemory(lpLink);
							}
						}
					}
				}
				break;

				case TVN_KEYDOWN:
				{
					return(0);
				}
				break;

				case TVN_ITEMEXPANDING:
				{
					TVITEMEX		tviex;

					if (bBuildingTree)
					{
						break;
					}
					if (lptv->action == TVE_EXPAND)
					{
						tviex.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_HANDLE;
						tviex.iImage = BOOKOPENIMAGE;
						tviex.iSelectedImage = BOOKOPENIMAGE;
						tviex.hItem = lptv->itemNew.hItem;
						TreeView_SetItem(hTreeView,&tviex);
						EmptyTheMessageQue();
						return(FALSE);
					}
					else if (lptv->action == TVE_COLLAPSE)
					{
						tviex.mask = TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_HANDLE;
						tviex.iImage = BOOKCLOSEDIMAGE;
						tviex.iSelectedImage = BOOKCLOSEDIMAGE;
						tviex.hItem = lptv->itemNew.hItem;
						TreeView_SetItem(hTreeView,&tviex);
						EmptyTheMessageQue();
						return(FALSE);
					}
				}
				break;

				case TVN_SELCHANGED:
				{
					ClearAllVariables();
					ClearMathVariables();

					if (bBuildingTree)
					{
						break;
					}
					// Check to see if we have a modified page. If we do, ask if
					// we want to save it or not. Otherwise, permit the change.
					//..........................................................
					if (PageModified(hDlg))
					{
						i = MessageBoxProc(hMainWindow,IDS_QUESTION,IDS_CHANGEPAGES,
										   MB_ICONQUESTION | MB_YESNO | MB_HELP,
										   MB_ICONQUESTION,0);
						if (i == IDYES)
						{
							SaveMyPage(hDlg);
							break;
						}
					}
					// Save the pointer to the current item.
					//......................................
					CopyMemory(&nmtvCurrent,lptv,sizeof(NMTREEVIEW));

					// If this is changed by the keyboard do not display it.
					//......................................................
					if (lptv->action == TVC_BYKEYBOARD)
					{
						break;
					}
					// If this is just click on a heading, let it go.
					//...............................................
					if (lptv->itemNew.lParam == -1)
					{
						break;
					}
					// Display the diary page.
					//........................
					DisplayDiaryPage(hDlg,lptv);
				}
				break;

				case TVN_SELCHANGING:
				{
					// If we are building the tree view, allow it.
					//............................................
					if (bBuildingTree)
					{
						return(FALSE);
					}
				}
				break;
			}
		}
		break;

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_PAGEDELETE:
				{
					if (!DiaryPage.bEdited)
					{
						uliMP.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,
														   uliMP.QuadPart,FILE_BEGIN);
						if (uliMP.QuadPart == -1)
						{
							break;
						}
						DiaryPage.bEdited = TRUE;
						bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryPage,
											   sizeof(DIARYPAGE),&dwBytesWritten,NULL);
						if (!bResult)
						{
							DiaryPage.bEdited = FALSE;
							break;
						}
						dwPagesDeleted++;
						SetDlgItemText(hDlg,IDC_MARK,(LPCTSTR)&szDeletePage);
						EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),FALSE);
						EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),TRUE);
						SetFocus(hTreeView); 
					}
				}
				break;

				case IDC_PAGEUNDELETE:
				{
					if (DiaryPage.bEdited)
					{
						uliMP.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,
														   uliMP.QuadPart,FILE_BEGIN);
						if (uliMP.QuadPart == -1)
						{
							break;
						}
						DiaryPage.bEdited = FALSE;
						bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryPage,
											   sizeof(DIARYPAGE),&dwBytesWritten,NULL);
						if (!bResult)
						{
							DiaryPage.bEdited = FALSE;
							break;
						}
						dwPagesDeleted--;
						SetDlgItemText(hDlg,IDC_MARK,lpszNullString);
						EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),TRUE);
						EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),FALSE);
						SetFocus(hTreeView);
					}
				}
				break;

				case IDC_MAILPAGE:
				{
					LPBYTE		lpSavedKey1;
					COLORREF	crSave;

					crSave = crBkgCurrent;

					// If we are not logged onto MAPI, do so.
					//.......................................
					if (!bLoggedOn)
					{
						bResult = LogonToMapi(IDH_OPEN_DIARY,FALSE,FALSE);
						if (!bResult)
						{
							break;
						}
					}
					EmptyTheMessageQue();

					// Restore the background color back to what it should be.
					//........................................................
					crBkgCurrent = crSave;

					cb = 0;
					cLines = SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETLINECOUNT,0,0L);

					if (cLines)
					{
						// Get the total number of bytes in the multi-line.
						//.................................................
						cb = SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_LINEINDEX,
											   (UINT)cLines - 1,0L);
						cb += SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_LINELENGTH,(UINT)cb,0L);
					}
					if (cb)
					{
						// Get the rich text data into a temporary file.
						//..............................................
						bResult = CreateFileStreamOut((LPTSTR)&szFileToEncipher,hDlg,
													   IDC_DIARYNOTE,SF_RTF,TRUE);
						if (!bResult)
						{
							break;
						}
						SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);
					}
					else
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_DIARYNOTEXT,
									   MB_ICONINFORMATION | MB_OK | MB_HELP,
									   MB_ICONINFORMATION,0);
						EnableWindow(hDlg,TRUE);
						SetFocus(GetDlgItem(hDlg,IDC_NOTE));
						break;
					}
					// Assign memory for the mapi message buffer.
					//...........................................
					lpmsg = (lpMapiMessage)PvAlloc(sizeof(MapiMessage));

					if (!lpmsg)
					{
						break;
					}
					ZeroMemory(lpmsg,sizeof(MapiMessage));
					lpszNoteText = NULL;
					lpmsg->flFlags = flSendMsgFlags;

					// Hide our diary page window.
					//............................
					ShowWindow(hDlg,SW_HIDE);
					EmptyTheMessageQue();

					// Save our lpKeyBuffer1 memory.
					//..............................
					lpSavedKey1 = lpKeyBuffer1;
					lpKeyBuffer1 = 0;

					bError = EncryptAnEmailMessage();

					lpKeyBuffer1 = lpSavedKey1;

					if (bError)
					{
						goto MailPageEnd;
					}
					// Send the message.
					//..................
					EmptyTheMessageQue();

					ulResult = MAPISendMail(lHandle,(ULONG)hMainWindow,lpmsg,MAPI_DIALOG,0);

					EmptyTheMessageQue();

					if (ulResult)
					{
						SetLastError(ulResult + MAPI_BASE);
						ErrorProcedure(lpMapiDllName,IDS_MAPI_SEND_MAIL,MB_OK);
					}

				  MailPageEnd:

					ShowWindow(hDlg,SW_SHOW);

					// If we have memory allocated, free it.
					//......................................
					if (lpmsg)
					{
						PvFree(lpmsg->lpszMessageType);
						PvFree(lpmsg->lpszConversationID);
						PvFree((LPBYTE)lpmsg);
						PvFree(lpszNoteText);
						lpmsg = NULL;
						lpszNoteText = NULL;
					}
				}
				break;

				case IDC_CLEARPAGE:
				{
					HTREEITEM	hParent;

					ClearDiaryPage(hDlg);

					// Get the parent of the current item.
					//....................................
					if (!bNewPage)
					{
						hParent = TreeView_GetParent(hTreeView,nmtvCurrent.itemNew.hItem);
						PrevDiaryEntry.uliOffset.QuadPart = 0;
						TreeView_SelectItem(hTreeView,hParent);
					}
				}
				break;

				case IDC_NEWPAGE:
				{
					TVITEMEX	tviex;
					HTREEITEM	hParent;
					BOOL		bParentEntry = FALSE;

					// Get the parent of the current item.
					//....................................
					hParent = TreeView_GetParent(hTreeView,nmtvCurrent.itemNew.hItem);

					tviex.mask = TVIF_PARAM;
					tviex.hItem = nmtvCurrent.itemNew.hItem;
					TreeView_GetItem(hTreeView,&tviex);
					if (tviex.lParam == -1)
					{
						bParentEntry = TRUE;
					}
					// Since we can only get here if we are looking at or editing
					// and old page, check to see if we have made any modifications.
					//..............................................................
					if (PageModified(hDlg))
					{
						i = MessageBoxProc(hMainWindow,IDS_QUESTION,IDS_MODIFIEDPAGE,
										   MB_ICONQUESTION | MB_YESNO | MB_HELP,
										   MB_ICONQUESTION,0);
						if (i == IDYES)
						{
							SaveMyPage(hDlg);
						}
					}
					// Clear the old page and set the modify flags.
					//.............................................
					bNewPage = TRUE;

					ClearDiaryPage(hDlg);

					// Set the background color and font.
					//...................................
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETBKGNDCOLOR,0,
									  (LPARAM)(COLORREF)crSetBkgColor);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_ALL,
								      (LPARAM)&cfg.diarycf);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);

					ZeroMemory(&NewDiaryPage,sizeof(DIARYPAGE));
					CopyMemory(&NewDiaryPage.id,&szDiaryId,4);

					// Set the local date and time for date created.
					//..............................................
					SetLocalDateTime(hDlg);

					SetDlgItemText(hDlg,IDC_MARK,lpszNullString);
					EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),FALSE);

					if (!bParentEntry)
					{
						TreeView_SelectItem(hTreeView,hParent);
					}
					if (NewDiaryPage.uliDateCreated.QuadPart < uliLastDate.QuadPart)
					{
						SetLastError(IDS_DIARYDATEINVALID);
						ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
						DestroyWindow(hDlg);
					}
					else
					{
						SetDlgItemText(hDlg,IDC_PAGEMODIFIED,lpszNullString);
						EnableWindow(GetDlgItem(hDlg,IDC_NEWPAGE),FALSE);
						ZeroMemory(&PrevDiaryEntry,sizeof(DIARYENTRY));
					}
				}
				break;

				case IDC_SAVEPAGE:
				{
					if (!bNewPage && !PageModified(hDlg))
					{
						break;
					}
					SaveMyPage(hDlg);

					SetDlgItemText(hDlg,IDC_MARK,lpszNullString);
					EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),FALSE);
				}
				break;

				case IDC_FONT:
				{
					SelectCharFormat(hDlg,GetDlgItem(hDlg,IDC_DIARYNOTE),(LPBYTE)&cfg.diarycf);
				}
				break;

				case IDC_BKG:
				{
					ZeroMemory(&crBkg,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;
					bChooseBkgColor = TRUE;

					crBkg.lStructSize = sizeof(CHOOSECOLOR);
					crBkg.hwndOwner = hDlg;
					crBkg.rgbResult = crBkgCurrent;
					crBkg.lpCustColors = (LPDWORD)cfg.crBkgCustom;
					crBkg.lpfnHook = MyCCHookProc;
					crBkg.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crBkg))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						crBkgCurrent = crBkg.rgbResult;
						crSetBkgColor = crBkg.rgbResult;
						crOleBkg = crBkgCurrent;
						SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETBKGNDCOLOR,0,
										  (LPARAM)(COLORREF)crBkgCurrent);
					}
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_TEXTCLR:
				{
					ZeroMemory(&crText,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;
					bChooseBkgColor = FALSE;

					crText.lStructSize = sizeof(CHOOSECOLOR);
					crText.hwndOwner = hDlg;
					crText.rgbResult = crTextCurrent;
					crText.lpCustColors = (LPDWORD)cfg.crTextCustom;
					crText.lpfnHook = MyCCHookProc;
					crText.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crText))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						crTextCurrent = crText.rgbResult;

						// Get the current font information from the rich edit control.
						//.............................................................
						SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,
								          (LPARAM)&cf);
						cf.crTextColor = crTextCurrent;
						SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,
										  (LPARAM)&cf);

						SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_EXGETSEL,0,(LPARAM)&cr);

						// Only save the new text color if it pertains to the
						// whole control and not just a selection.
						//...................................................
						if (cr.cpMax == cr.cpMin)
						{
							// Save the text color selection.
							//...............................
							CopyMemory(&cfg.diarycf,&cf,sizeof(CHARFORMAT2));
						}
					}
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_BOLD:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_BOLD;
					SendMessage(GetDlgItem(hDlg,IDC_DIARYNOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_BOLD;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_BOLD);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_BOLD,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_ITALIC:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_ITALIC;
					SendMessage(GetDlgItem(hDlg,IDC_DIARYNOTE),EM_GETCHARFORMAT,TRUE,(LPARAM)&cf);
					cf.dwEffects ^= CFE_ITALIC;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_ITALIC);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_ITALIC,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_UNDERLINE:
				{
					// Toggle the bold effect.
					//........................
					cf.dwMask = CFM_UNDERLINE | CFM_UNDERLINETYPE;
					SendMessage(GetDlgItem(hDlg,IDC_DIARYNOTE),EM_GETCHARFORMAT,TRUE,
							   (LPARAM)&cf);
					cf.dwEffects ^= CFE_UNDERLINE;

					// If we have rich edit 3.0 or greater we can select the
					// type of underline we have if we are setting it.
					//......................................................
					if (bHaveRichEdit3 && (cf.dwEffects & CFE_UNDERLINE))
					{
						EnableWindow(hDlg,FALSE);

						iDlgResult = DialogBox(hInst,TEXT("SELECTUNDERLINE"),hDlg,
											  (DLGPROC)SelectUnderlineProc);
						EnableWindow(hDlg,TRUE);

						// See if we had a system error in creating the dialog box.
						//.........................................................
						if (iDlgResult == -1)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);	
							SetFocus(GetDlgItem(hDlg,IDC_NOTE));
							break;
						}
						// Quit if we canceled.
						//.....................
						if (iDlgResult == IDCANCEL)
						{
							SetFocus(GetDlgItem(hDlg,IDC_NOTE));
							break;
						}

					}
					// Set our settings for underlining.
					//..................................
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,
									  (LPARAM)&cf);

					// Now we have to toggle the bold radiobutton.
					//............................................
					uCheck = IsDlgButtonChecked(hDlg,IDC_UNDERLINE);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
					}
					else
					{
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_UNDERLINE,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_LEFT:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_LEFT;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_LEFT);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_CENTER:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_CENTER;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_CENTER);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_RIGHT:
				{
					pf.dwMask = PFM_ALIGNMENT;
					pf.wAlignment = PFA_RIGHT;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckRadioButton(hDlg,IDC_LEFT,IDC_RIGHT,IDC_RIGHT);
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_BULLETS:
				{
					pf.dwMask = PFM_NUMBERING;
					if (IsDlgButtonChecked(hDlg,IDC_BULLETS))
					{
						pf.wNumbering = 0;
						uCheck = BST_UNCHECKED;
					}
					else
					{	
						// If we have Richedit 3.0 or above we can select bullets
						// and styles.
						//.......................................................
						if (bHaveRichEdit3)
						{
							pf.cbSize = sizeof(PARAFORMAT2);
							SendMessage(GetDlgItem(hDlg,IDC_DIARYNOTE),EM_GETPARAFORMAT,0,
												  (LPARAM)&pf);

							EnableWindow(hDlg,FALSE);

							iDlgResult = DialogBox(hInst,TEXT("BULLETS"),hDlg,
												   (DLGPROC)BulletsProc);
							// See if we had a system error in creating the dialog box.
							//.........................................................
							if (iDlgResult == -1)
							{
								ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
								EnableWindow(hDlg,TRUE);
								SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
								break;
							}
							// Quit if we canceled.
							//.....................
							if (iDlgResult == IDCANCEL)
							{
								EnableWindow(hDlg,TRUE);
								SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
								break;
							}
							pf.wNumberingStart = 1;
							if (pf.wNumbering > PFN_BULLET)
							{
								pf.dwMask = (PFM_NUMBERING | PFM_NUMBERINGSTART | PFM_NUMBERINGSTYLE | 
										     PFM_NUMBERINGTAB | PFM_OFFSET | PFM_STARTINDENT);
							}
							else
							{
								pf.dwMask = PFM_NUMBERING;
							}
							EnableWindow(hDlg,TRUE);
						}
						else
						{
							pf.wNumbering = PFN_BULLET;
						}
						uCheck = BST_CHECKED;
					}
					cf.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cf);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cf);
					pf.cbSize = sizeof(PARAFORMAT2);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETPARAFORMAT,0,(LPARAM)&pf);
					CheckDlgButton(hDlg,IDC_BULLETS,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_RETURN:
				{
					if (IsDlgButtonChecked(hDlg,IDC_RETURN))
					{
						bReturnReceipt = FALSE;
						uCheck = BST_UNCHECKED;
					}
					else
					{
						bReturnReceipt = TRUE;
						uCheck = BST_CHECKED;
					}
					CheckDlgButton(hDlg,IDC_RETURN,uCheck);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;

				case IDC_SPELLCHECK:
				{
//					SHORT		sError;
//					DWORD		dwStart;
//					DWORD		dwEnd;

//					dwSpellHelp = ChangeHelpTopic(IDH_SPELL_CHECKER);

					// Determine if we only have a selection to test.
					//...............................................
//					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_EXGETSEL,0,(LPARAM)&cr);

//					if (cr.cpMax == cr.cpMin)
//					{
//						sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//													    GetDlgItem(hDlg,IDC_DIARYNOTE),
//														FALSE,hInst,&szCheckSpellingDlg,
//														&szEditLexDlg,&szOptionsDlg,
//														&szNewLexDlg);
//					}
//					else
//					{
//						sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//														GetDlgItem(hDlg,IDC_DIARYNOTE),
//														TRUE,hInst,&szCheckSpellingDlg,
//														&szEditLexDlg,&szOptionsDlg,
//														&szNewLexDlg);
//					}
//					SentrySpellError(sError);
//					SetUserLexiconFiles();
//					EmptyTheMessageQue();

					// Now check the spelling in the keywords edit controls.
					//......................................................
//					SendDlgItemMessage(hDlg,IDC_KW1,EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);

//					if (dwEnd > 0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//														    GetDlgItem(hDlg,IDC_KW1),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//														    GetDlgItem(hDlg,IDC_KW1),
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

//					SendDlgItemMessage(hDlg,IDC_KW2,EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);

//					if (dwEnd > 0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW2),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW2),
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

//					SendDlgItemMessage(hDlg,IDC_KW3,EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);

//					if (dwEnd > 0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW3),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW3),
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

//					SendDlgItemMessage(hDlg,IDC_KW4,EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);

//					if (dwEnd >0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW4),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW4),
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

//					SendDlgItemMessage(hDlg,IDC_KW5,EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);

//					if (dwEnd > 0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW5),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW5),
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

//					SendDlgItemMessage(hDlg,IDC_KW6,EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);

//					if (dwEnd > 0)
//					{
//						if (dwStart == dwEnd)
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW6),
//															FALSE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						else
//						{
//							sError = SSCE_CheckCtrlDlgTmplt(hMainWindow,
//															GetDlgItem(hDlg,IDC_KW6),	
//															TRUE,hInst,&szCheckSpellingDlg,
//															&szEditLexDlg,&szOptionsDlg,
//															&szNewLexDlg);
//						}
//						SentrySpellError(sError);
//						SetUserLexiconFiles();
//					}
//					EmptyTheMessageQue();

					SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));

					ChangeHelpTopic(dwSpellHelp);
				}
				break;

				case IDCANCEL:
				{
					if (bBuildingTree)
					{
						break;
					}
					// Check to make sure we are not exiting with a page to save.
					//...........................................................
					if (PageModified(hDlg))
					{
						i = MessageBoxProc(hMainWindow,IDS_QUESTION,IDS_CLOSEWITHPAGE,
										   MB_ICONQUESTION | MB_YESNOCANCEL | MB_HELP,
										   MB_ICONQUESTION,0);
						if (i == IDCANCEL)
						{
							SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
							break;
						}
						if (i == IDYES)
						{
							SaveMyPage(hDlg);
						}
					}
					// Make sure we save any background color we set.
					//...............................................
					cfg.diarycf.crBackColor = crSetBkgColor;

					// Set all of the controls in the dialog box to empty strings.
					//............................................................
					SendDlgItemMessage(hDlg,IDC_KW1,WM_SETTEXT,0,(LPARAM)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_KW2,WM_SETTEXT,0,(LPARAM)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_KW3,WM_SETTEXT,0,(LPARAM)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_KW4,WM_SETTEXT,0,(LPARAM)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_KW5,WM_SETTEXT,0,(LPARAM)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_KW6,WM_SETTEXT,0,(LPARAM)lpszNullString);
					SendDlgItemMessage(hDlg,IDC_DIARYNOTE,WM_SETTEXT,0,(LPARAM)lpszNullString);
					DestroyWindow(hDlg);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			HWND		hControl;
			
			hControl = GetDlgItem(hDlg,IDC_DIARYNOTE);
			
			if (hControl == (HWND)wParam)
			{
				RtfContextMenu(hDlg,(HWND)wParam,lParam,IDC_DIARYNOTE);
			}
			else
			{
				WhatsThis(hDlg,(HWND)wParam,lParam);
			}
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			DestroyIcon(hDiaryIcon);
			ImageList_Destroy(hDiaryListSmall);

			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			if (hDlgFont2)
			{
				DeleteObject(hDlgFont2);
				hDlgFont2 = 0;
			}
			// Notify the compose note procedure that it can
			// continue.
			//..............................................
			SetEvent(hDiaryEvent);
		}
		break;

		default:
		{
			if (uiMsg == uComDlgHelpMsg && uComDlgHelpMsg)
			{
				DisplayMyHelp(hDlg);
			}
			else if (uiMsg == uFindMsgString && uFindMsgString)
			{
				lpFr = (LPFINDREPLACE)lParam;
				MyFindDlgBox();
			}
			else
			{
				return(FALSE);
			}
			break;
		}
	}
	return(TRUE);
}

// Save a journal page.
//.....................
VOID SaveMyPage(HWND hDlg)
{
	HANDLE			hEncFile = 0;
	LARGE_INTEGER	liPkdFileSize;
	HANDLE			hTempFile = 0;
	ULARGE_INTEGER	uli;
	LARGE_INTEGER	li;
	BOOL			bPageSavedToDisk = FALSE;
	BOOL			bPageError = TRUE;
	BOOL			bInit;
	LONG			cb;
	LONG			cLines;
	int				iError;
	BOOL			bError;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	TCHAR			szBuffer[128];
	TCHAR			szBuffer1[128];
	TCHAR			szBuffer2[128];

	lpInBuffer = 0;
	lpOutBuffer = 0;
	bInit = FALSE;

	if (!bNewPage)
	{
		ZeroMemory(&NewDiaryPage,sizeof(DIARYPAGE));
		CopyMemory(&NewDiaryPage.id,&szDiaryId,4);
		NewDiaryPage.uliDateCreated.QuadPart = DiaryPage.uliDateCreated.QuadPart;
		NewDiaryPage.uliDateCreated.QuadPart++;
		NewDiaryPage.uliLastModified.QuadPart = GetTimestamp(FALSE);
	}
	// Make sure we have text to save.
	//................................
	bTempStreamOut = FALSE;
	cb = 0;
	cLines = SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETLINECOUNT,0,0L);

	if (cLines)
	{
		// Get the total number of bytes in the multi-line.
		//.................................................
		cb = SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_LINEINDEX,(UINT)cLines - 1,0L);
		cb += SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_LINELENGTH,(UINT)cb,0L);
	}
	if (cb)
	{
		// Get the rich text data into a temporary file.
		//..............................................
		bResult = CreateFileStreamOut((LPTSTR)&szDiaryStreamOut,hDlg,
									   IDC_DIARYNOTE,SF_RTF,TRUE);
		if (!bResult)
		{
			return;
		}
		bTempStreamOut = TRUE;
	}
	else
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_DIARYNOTEXT,
					   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
		EnableWindow(hDlg,TRUE);
		SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));
		return;
	}
	// We have saved our page to a temporay text file.
	// Retrieve the keywords.
	//................................................
	GetDlgItemText(hDlg,IDC_KW1,(LPTSTR)&NewDiaryPage.kw1,MAX_KEYWORD);
	GetDlgItemText(hDlg,IDC_KW2,(LPTSTR)&NewDiaryPage.kw2,MAX_KEYWORD);
	GetDlgItemText(hDlg,IDC_KW3,(LPTSTR)&NewDiaryPage.kw3,MAX_KEYWORD);
	GetDlgItemText(hDlg,IDC_KW4,(LPTSTR)&NewDiaryPage.kw4,MAX_KEYWORD);
	GetDlgItemText(hDlg,IDC_KW5,(LPTSTR)&NewDiaryPage.kw5,MAX_KEYWORD);
	GetDlgItemText(hDlg,IDC_KW6,(LPTSTR)&NewDiaryPage.kw6,MAX_KEYWORD);

	// Set the current background color.
	//..................................
	NewDiaryPage.crBkg = crBkgCurrent;

	// Compress the diary entry file.
	//...............................
	hEncFile = CreateMyFile((LPTSTR)&szDiaryStreamOut,GENERIC_READ,0,NULL,
						     OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hEncFile)
	{
		return;
	}
	liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szDiaryStreamOut,hEncFile);
	liPkdFileSize.QuadPart = liEncFileSize.QuadPart;
	if (liEncFileSize.QuadPart == -1)
	{
		goto DiaryCleanUp;
	}
	// Compress the file.
	//...................
	CopyMemory(&szPkdRtfFile,&szDiaryStreamOut,MAX_PATH);
	PathRemoveExtension((LPTSTR)&szPkdRtfFile);
	StringCbCatEx((LPTSTR)&szPkdRtfFile,sizeof(szPkdRtfFile),TEXT(".pdk"),NULL,NULL,
				   dwStringSafeFlag);

	// Create the ouput file.
	//.......................
	hTempFile = CreateMyFile((LPTSTR)&szPkdRtfFile,GENERIC_READ | GENERIC_WRITE,
							  0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hTempFile)
	{
		goto DiaryCleanUp;
	}
	// Setup the size of the input and output buffers.
	//................................................
	lpInBuffer = AllocateMemory(liEncFileSize.LowPart);

	if (!lpInBuffer)
	{
		goto DiaryCleanUp;
	}
	// Read the diary entry into memory.
	//..................................
	bResult = ReadMyFile((LPTSTR)&szDiaryStreamOut,hEncFile,lpInBuffer,
						  liEncFileSize.LowPart,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	// Setup the compressed diary header.
	//...................................
	CopyMemory(&Msghdr.MsgId,&szPkdDiaryId,4);
	Msghdr.dwMsgSize = liEncFileSize.LowPart;

	// Do the crc32 for diary entry.
	//..............................
	Msghdr.dwMsgCrc32 = crc32(0L,Z_NULL,0);
	Msghdr.dwMsgCrc32 = crc32(Msghdr.dwMsgCrc32,lpInBuffer,liEncFileSize.LowPart);

	// Setup the z_stream.
	//....................
	ZeroMemory(&z,sizeof(z));

	iError = deflateInit(&z,Z_BEST_COMPRESSION);
	if (iError != Z_OK)
	{
		ZlibError((LPBYTE)&szDiaryStreamOut,iError,IDS_DEFLATEINIT);
		goto DiaryCleanUp;
	}
	bInit = TRUE;

	uli.HighPart = 0;
	uli.LowPart = deflateBound(&z,liEncFileSize.LowPart);

	lpOutBuffer = AllocateMemory(uli.LowPart);

	if (!lpOutBuffer)
	{
		goto DiaryCleanUp;
	}
	z.avail_in = liEncFileSize.LowPart;
	z.avail_out = uli.LowPart;
	z.next_in = lpInBuffer;
	z.next_out = lpOutBuffer;

	// Compress the diary page.
	//.........................
	iError = deflate(&z,Z_FINISH);
	if (iError < 0)
	{
		ZlibError((LPBYTE)&szDiaryStreamOut,iError,IDS_DEFLATE);
		goto DiaryCleanUp;
	}
	if (iError != Z_STREAM_END)
	{
		ZlibError((LPBYTE)&szDiaryStreamOut,Z_DATA_ERROR,IDS_DEFLATE);
		goto DiaryCleanUp;
	}
	iError = deflateEnd(&z);
	if (iError != Z_OK)
	{
		ZlibError((LPBYTE)&szDiaryStreamOut,iError,IDS_DEFLATEEND);
		goto DiaryCleanUp;
	}
	bInit = FALSE;

	Msghdr.dwCompressedMsgSize = z.total_out;

	// Write the header to disk.
	//..........................
	bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,&Msghdr,sizeof(Msghdr),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,lpOutBuffer,z.total_out,
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	liEncFileSize.QuadPart = GetMyFileSize((LPTSTR)&szPkdRtfFile,hTempFile);
	if (liEncFileSize.QuadPart == -1)
	{
		goto DiaryCleanUp;
	}
	NewDiaryPage.dwDataLength = liEncFileSize.LowPart;

	// Setup to create the pke packet and encrypt the file.
	//.....................................................
	DecComponents();

	// Setup the random number generators.
	//....................................
	SetupDiaryRngs(lpMyKey->dwN_Bytes);

	RsaPubEnc(&Temp1,(LPBYTE)&rphdr,dwReproLength,(LPBYTE)lpMyKey->E_Temp,
			 (LPBYTE)lpMyKey->Modulus_N,lpMyKey->dwN_Bytes);

	EncComponents();

	if (bCancelOperation == TRUE)
	{
		goto DiaryCleanUp;
	}
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		NewDiaryPage.MPI_PREFIX,ax
	}
	CircleSwap((LPBYTE)&Temp1,dwCountBytes);

	// Copy the pke packet to the DIARYPAGE header.
	//.............................................
	CopyMemory(&NewDiaryPage.Pke,&Temp1,dwCountBytes);

	// Setup the arrays for encrypting the diary page.
	//................................................
	SetupDiaryArrays();
	Divisor1 = 256;

	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szPkdRtfFile,hTempFile,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto DiaryCleanUp;
	}
	// Loop through the file to encrypt it.
	//.....................................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szPkdRtfFile,hTempFile,lpKeyBuffer1,
							  ENC_BUFFER_SIZE,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		if (dwBytesRead == 0)
		{
			break;
		}
		ChangeBytes(lpKeyBuffer1,dwBytesRead);

		// Set the file pointer back to the start of the read.
		//....................................................
		li.QuadPart = SetMyFilePointer((LPTSTR)&szPkdRtfFile,hTempFile,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto DiaryCleanUp;
		}
		bResult = WriteMyFile((LPTSTR)&szPkdRtfFile,hTempFile,lpKeyBuffer1,
							   dwBytesRead,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		li.QuadPart += dwBytesWritten;
	}
	// Set the file pointer back to the beginning of the file.
	//........................................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szPkdRtfFile,hTempFile,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto DiaryCleanUp;
	}
	// Append the new diary page and encrypted data to the end of the
	// diary.
	//...............................................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_END);
	if (li.QuadPart == -1)
	{
		goto DiaryCleanUp;
	}
	// Write the header first.
	//........................
	bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,&NewDiaryPage,sizeof(DIARYPAGE),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szPkdRtfFile,hTempFile,lpKeyBuffer1,
							  ENC_BUFFER_SIZE,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		if (dwBytesRead == 0)
		{
			break;
		}
		bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,lpKeyBuffer1,dwBytesRead,
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
	}
	bPageSavedToDisk = TRUE;

	// We are done encrypting the page. Now update the index file
	// and the tree view control.
	//...........................................................
	ZeroMemory(&DiaryEntry,sizeof(DIARYENTRY));
	ZeroMemory(&szBuffer,sizeof(szBuffer));
	DiaryEntry.uliOffset.QuadPart = li.QuadPart;
	DiaryEntry.Type_Entry = 1;
	CopyMemory(&DiaryEntry.KeyWord,&szCharA,sizeof(szCharA));

	// Convert the date and time for this entry.
	//..........................................
	TimestampToDateTime(NewDiaryPage.uliDateCreated.QuadPart,&DiaryEntry.st);

	if (bNewPage)
	{
		// Put the date time of the last creation in the end header.
		//..........................................................
		uliLastDate.QuadPart = NewDiaryPage.uliDateCreated.QuadPart;
	}
	// Get the date/time stamp in proper order for sorting.
	//.....................................................
	DiaryEntry.dwCreated[0] = NewDiaryPage.uliDateCreated.HighPart;
	DiaryEntry.dwCreated[1] = NewDiaryPage.uliDateCreated.LowPart;

	// Convert the date and time to a string format.
	//..............................................
	GetDateFormat(LOCALE_USER_DEFAULT,0,&DiaryEntry.st,"ddd',' dd MMM yyyy",
				  szBuffer1,sizeof(szBuffer1));
	StringCbPrintf((LPTSTR)&szBuffer2,sizeof(szBuffer2),szTime,DiaryEntry.st.wHour,&TimeSep,
				    DiaryEntry.st.wMinute,&TimeSep,DiaryEntry.st.wSecond);
	StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szDateTimeFmt,&szBuffer1,
					&szBuffer2);
	CopyMemory(&DiaryEntry.Date_Time,&szBuffer,sizeof(DiaryEntry.Date_Time));

	// Get the year as four digits.
	//.............................
	StringCbPrintf((LPTSTR)&DiaryEntry.Year,sizeof(DiaryEntry.Year),TEXT("%u"),
					DiaryEntry.st.wYear);

	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szIndexTemp,hIndexTemp,li.QuadPart,FILE_END);
	if (li.QuadPart == -1)
	{
		goto DiaryCleanUp;
	}
	// Write the entry to disk.
	//.........................
	bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,sizeof(DIARYENTRY),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	dwIndexEntries++;
	dwJrlPages++;

	// Now process the entries for the keywords.
	//..........................................
	if (*NewDiaryPage.kw1 != 0)
	{
		DiaryEntry.Type_Entry = 2;
		CopyMemory(&DiaryEntry.KeyWord,&NewDiaryPage.kw1,sizeof(DiaryEntry.KeyWord));

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
							   sizeof(DIARYENTRY),&dwBytesWritten,NULL);	
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		dwIndexEntries++;
		dwJrlKeywords++;
	}
	if (*NewDiaryPage.kw2 != 0)
	{
		DiaryEntry.Type_Entry = 2;
		CopyMemory(&DiaryEntry.KeyWord,&NewDiaryPage.kw2,sizeof(DiaryEntry.KeyWord));

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
							   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		dwIndexEntries++;
		dwJrlKeywords++;
	}
	if (*NewDiaryPage.kw3 != 0)
	{
		DiaryEntry.Type_Entry = 2;
		CopyMemory(&DiaryEntry.KeyWord,&NewDiaryPage.kw3,sizeof(DiaryEntry.KeyWord));

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
							   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		dwIndexEntries++;
		dwJrlKeywords++;
	}
	if (*NewDiaryPage.kw4 != 0)
	{
		DiaryEntry.Type_Entry = 2;
		CopyMemory(&DiaryEntry.KeyWord,&NewDiaryPage.kw4,sizeof(DiaryEntry.KeyWord));

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
							   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		dwIndexEntries++;
		dwJrlKeywords++;
	}
	if (*NewDiaryPage.kw5 != 0)
	{
		DiaryEntry.Type_Entry = 2;
		CopyMemory(&DiaryEntry.KeyWord,&NewDiaryPage.kw5,sizeof(DiaryEntry.KeyWord));

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
							   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		dwIndexEntries++;
		dwJrlKeywords++;
	}
	if (*NewDiaryPage.kw6 != 0)
	{
		DiaryEntry.Type_Entry = 2;
		CopyMemory(&DiaryEntry.KeyWord,&NewDiaryPage.kw6,sizeof(DiaryEntry.KeyWord));

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
							   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		dwIndexEntries++;
		dwJrlKeywords++;
	}
	bResult = FlushMyFile((LPTSTR)&szIndexTemp,hIndexTemp);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	// Sort the updated index file.
	//.............................
	bResult = SortMyFile((LPTSTR)&szIndexTemp,hIndexTemp,0,&DiarySort,ASCENDING);
	if (!bResult)
	{
		goto DiaryCleanUp;
	}
	// If this was a modified page, we have to update the diary header
	// for the original page and disable the new page button.
	//................................................................
	if (!bNewPage)
	{
		DiaryPage.bEdited = TRUE;
		uliMP.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,uliMP.QuadPart,
										   FILE_BEGIN);
		if (uliMP.QuadPart == -1)
		{
			goto DiaryCleanUp;
		}
		bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryPage,
							   sizeof(DIARYPAGE),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto DiaryCleanUp;
		}
		// Disable the new page button.
		//.............................
		EnableWindow(GetDlgItem(hDlg,IDC_NEWPAGE),FALSE);
		bDiaryPageModified = TRUE;
	}
	// If we did not have an error we have to make a new diary page.
	//..............................................................
	bNewPage = TRUE;

	ClearDiaryPage(hDlg);

	ZeroMemory(&NewDiaryPage,sizeof(DIARYPAGE));
	CopyMemory(&NewDiaryPage.id,&szDiaryId,4);

	// Set the local date and time for date created.
	//..............................................
	SetLocalDateTime(hDlg);

	SetDlgItemText(hDlg,IDC_PAGEMODIFIED,lpszNullString);
	ZeroMemory(&PrevDiaryEntry,sizeof(DIARYENTRY));

	bError = AddItemsToTreeView();
	if (bError)
	{
		goto DiaryCleanUp;
	}
	bPageError = FALSE;

	DiaryCleanUp:

	EmptyTheMessageQue();

	ClearAllVariables();
	ClearMathVariables();

	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,liPkdFileSize.LowPart);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,uli.LowPart);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (hEncFile)
	{
		CloseMyHandle((LPTSTR)&szDiaryStreamOut,hEncFile);
		WipeMyFile((LPBYTE)&szDiaryStreamOut,TRUE);
	}
	if (hTempFile)
	{
		CloseMyHandle((LPTSTR)&szPkdRtfFile,hTempFile);
		WipeMyFile((LPTSTR)&szPkdRtfFile,TRUE);
	}
	if (bPageSavedToDisk)
	{
		MessageBoxProc(hDlg,IDS_ADVISORY,IDS_PAGESAVED,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	if (bPageError)
	{
		MessageBoxProc(hDlg,IDS_ADVISORY,IDS_DIARYPAGEERROR,
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
	}
}

// Display a diary page.
//......................
VOID DisplayDiaryPage(HWND hDlg, LPNMTREEVIEW lptv)
{
	DIARYPAGE		SavedDiaryPage;
	BOOL			bNotChanged = TRUE;
	LPBYTE			lpDiaryPage = 0;
	LPBYTE			lpDiaryPageDup;
	LPBYTE			lpDiaryPage1 = 0;
	SYSTEMTIME		stLocal;
	EDITSTREAM		eStream;
	BOOL			bInit;
	BOOL			bResult;
	BOOL			bError;
	DWORD			dwBytesRead;
	DWORD			dwResult;
	DWORD			dwRsaIntegerBits;
	DWORD			dwRsaIntegerBytes;
	DWORD			dwCheckSum;
	DWORD			dwHdrCheckSum;
	int				i, iError;
	TCHAR			szBuffer[128];
	TCHAR			szBuffer1[128];
	TCHAR			szBuffer2[128];
	TCHAR			szBuffer3[128];
	TCHAR			szOutBuffer[512];

	bInit = FALSE;

	// Save the DIARYPAGE in case we have an error and have
	// to restore it.
	//.....................................................
	CopyMemory(&SavedDiaryPage,&DiaryPage,sizeof(DIARYPAGE));

	// We have a new page to display. Get it and decrypt it.
	//......................................................
	uliMP.QuadPart = 0;
	uliMP.QuadPart = lptv->itemNew.lParam;
	uliMP.QuadPart *= sizeof(DIARYENTRY);

	// Set the file pointer to get the diary entry.
	//.............................................
	uliMP.QuadPart = SetMyFilePointer((LPTSTR)&szIndexTemp,hIndexTemp,
									   uliMP.QuadPart,FILE_BEGIN);
	if (uliMP.QuadPart == -1)
	{
		return;
	}
	// Read in the diary entry.
	//.........................
	bResult = ReadMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
						  sizeof(DIARYENTRY),&dwBytesRead,NULL);
	if (!bResult)
	{
		return;
	}
	if (dwBytesRead != sizeof(DIARYENTRY))
	{
		SetLastError(IDS_INVALIDINDEXENTRY);
		ErrorProcedure((LPTSTR)&szIndexTemp,IDS_READ,MB_OK);
		return;
	}
	// Read in the DIARYPAGE for this entry.
	//......................................
	uliMP.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,
									   DiaryEntry.uliOffset.QuadPart,FILE_BEGIN);
	if (uliMP.QuadPart == -1)
	{
		return;
	}
	// If this points to the same diary page we can bail out.
	//.......................................................
	if (!bNewPage)
	{
		if (PrevDiaryEntry.uliOffset.QuadPart == DiaryEntry.uliOffset.QuadPart)
		{
			return;
		}
	}
	// Read in the diary page.
	//........................
	bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryPage,sizeof(DIARYPAGE),
						  &dwBytesRead,NULL);
	if (!bResult)
	{
		goto ChangeEnd;
	}
	if (dwBytesRead != sizeof(DIARYPAGE))
	{
		SetLastError(IDS_INVALIDDIARYPAGE);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	// Make sure it has the proper id.
	//................................
	i = CompareString(LOCALE_USER_DEFAULT,0,(LPTSTR)&DiaryPage.id,4,(LPCTSTR)&szDiaryId,4);
	if (i != CSTR_EQUAL)
	{
		SetLastError(IDS_INVALIDDIARYPAGE);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	dwRsaIntegerBits =(WORD)DiaryPage.MPI_PREFIX;

	__asm
	{
		mov		eax,dwRsaIntegerBits
		xchg	ah,al
		mov		dwRsaIntegerBits,eax
		add		eax,7
		shr		eax,3
		mov		dwRsaIntegerBytes,eax
	}
	if (dwRsaIntegerBits > MAX_BITS)
	{
		SetLastError(IDS_DIARYKEYNOGOOD);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	// Decipher the secret key components.
	//....................................
	DecComponents();

	// Decrypt the pke packet and get the key to decrypt the diary page.
	//..................................................................
	CopyMemory(&Temp9,&DiaryPage.Pke,dwRsaIntegerBytes);
	CircleSwap((LPBYTE)&Temp9,dwRsaIntegerBytes);

	// The number of bits in the rsa integer must be less than
	// or equal to the number of bits in modulus n in the 
	// Secret Key.
	//........................................................
	if (dwRsaIntegerBits > lpMyKey->dwN_Bits)
	{
	  InvalidRsaInteger:
		SetLastError(IDS_RSAINTEGERGTEMODULUSN);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	// If the number of bits are equal, do an actual comparision to
	// make sure the rsa integer is less than modulus n.
	//.............................................................
	if (dwRsaIntegerBits == lpMyKey->dwN_Bits)
	{
		dwResult = MpCompareDW((LPBYTE)lpMyKey->Modulus_N,(LPBYTE)&Temp9,MAX_MOD_DWORD);
		if (dwResult ==	0 || dwResult == 1)
		{
			goto InvalidRsaInteger;
		}
	}
	// Setup our elapsed timer.
	//.........................
	dwElapHours = 0;
	dwElapMinutes = 0;
	dwElapSeconds = 0;
	uTimer = SetTimer(hMainWindow,MY_TIMER,1000,(TIMERPROC)My1SecondTimer);

	DisplayZeroTimer();
	EmptyTheMessageQue();

	// Decrypt our pke packet.
	//........................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("DECRYPTPKEPACKETDIARY"),hMainWindow,
								  (DLGPROC)DecryptPkePacketDiaryProc);
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto ChangeEnd;
	}
	bError = RsaPriDec((LPBYTE)&Temp6,(LPBYTE)&Temp9,(LPBYTE)lpMyKey->D_Temp,
					  (LPBYTE)lpMyKey->Prime_P,(LPBYTE)lpMyKey->Prime_Q,\
					  (LPBYTE)lpMyKey->U_Temp,lpMyKey->dwN_Bytes);

	EmptyTheMessageQue();

	if (bCancelOperation == TRUE)
	{
		goto ChangeEnd;
	}
	// Check to see if we had an error.
	//.................................
	if (bError)
	{
		SetLastError(IDS_RSAPRIVATEDECRYPTERROR);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	// Setup the random key to decipher the diary file.
	//.................................................
	if (dwCountBytes == KEY_4_LGTH || dwCountBytes == KEY_8_LGTH ||
		dwCountBytes == KEY_16_LGTH || dwCountBytes == KEY_32_LGTH ||
		dwCountBytes == KEY_64_LGTH || dwCountBytes == KEY_128_LGTH)
	{
		dwReproLength = dwCountBytes;
		CopyMemory(&rphdr,&Temp6,dwCountBytes);
	}
	else
	{
		// We have a key length we cannot deal with.
		//..........................................
		SetLastError(IDS_INVALIDKEYLENGTH);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	// Check out the checksum to make sure it is correct.
	//...................................................
	lpCsumOffset = (LPBYTE)&rphdr;
	lpSeedOffset = (LPBYTE)&rphdr;

	dwRngsUsed = RNGS_128;

	if (dwReproLength == KEY_4_LGTH)
	{
		dwRngsUsed = RNGS_4;
	}
	else if (dwReproLength == KEY_8_LGTH)
	{
		dwRngsUsed = RNGS_8;
	}
	else if (dwReproLength == KEY_16_LGTH)
	{
		dwRngsUsed = RNGS_16;
	}
	else if (dwReproLength == KEY_32_LGTH)
	{
		dwRngsUsed = RNGS_32;
	}
	else if (dwReproLength == KEY_64_LGTH)
	{
		dwRngsUsed = RNGS_64;
	}
	lpCsumOffset += (dwReproLength - SIZE_OF_CSUM);
	lpSeedOffset += (dwReproLength - SIZE_OF_CSUM - SIZE_OF_SEED);

	__asm
	{
		mov		eax,dwRngsUsed
		mov		RingMask,al
		dec		RingMask
	}
	// Calculate and check the checksum of the header.
	//................................................
	__asm
	{
		mov		esi,lpCsumOffset
		movzx	eax,word ptr [esi]
		xchg	ah,al
		mov		dwHdrCheckSum,eax
	}
	dwCheckSum = CheckSum((LPBYTE)&rphdr,(dwReproLength - SIZE_OF_CSUM));
	if (dwHdrCheckSum != dwCheckSum)
	{
		SetLastError(IDS_PKECSUMINVALID);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	__asm
	{
		mov		esi,lpSeedOffset
		mov		eax,dword ptr [edi]
		mov		Seed,eax
	}
	// Setup the random number generators.
	// Setup the factor array first, followed by the tops and
	// seeds arrays.
	//.......................................................
	__asm
	{
		mov		eax,dwRngsUsed
		mov		ecx,SIZE_OF_SEED
		mul		ecx
		mov		ecx,eax
		push	ecx
		push	ecx
		mov		esi,offset rphdr
		mov		edi,offset FactorArray
		rep		movsb
		pop		ecx
		mov		edi,offset TopsArray
		rep		movsb
		pop		ecx
		mov		edi,offset SeedsArray
		rep		movsb

		// Setup the first LastSeed value.
		//................................
		mov		al,byte ptr rphdr[12]
		and		al,RingMask
		mov		LastSeed,al

		// Setup the DbleNumber value.
		//............................
		mov		esi,lpSeedOffset
		mov		eax,dword ptr [esi-7]
		clc
		rcl		eax,1
		jnc		L1
		mov		eax,-1
	L1:	mov		DbleNumber,eax
	}
	ZeroMemory(&rphdr,MAX_REPRO_LGTH);
	Divisor1 = 256;

	// We will decrypt the diary page in memory. We should
	// have enough.
	//....................................................
	lpDiaryPage = AllocateMemory(DiaryPage.dwDataLength);
	if (!lpDiaryPage)
	{
		goto ChangeEnd;
	}
	// The file pointer is at the position to read the encyrpted data.
	//................................................................
	bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,lpDiaryPage,
						  DiaryPage.dwDataLength,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto ChangeEnd;
	}
	if (dwBytesRead != DiaryPage.dwDataLength)
	{
		SetLastError(IDS_INVALIDDIARYPAGE);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	ChangeBytes(lpDiaryPage,dwBytesRead);

	ClearAllVariables();
	ClearMathVariables();
	EncComponents();

	// Now make sure we have data to decompress.
	//..........................................
	CopyMemory(&Msghdr,lpDiaryPage,sizeof(MSG_HEADER));

	i = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Msghdr,4,(LPCTSTR)&szPkdDiaryId,4);
	if (i != CSTR_EQUAL)
	{
		SetLastError(IDS_EXPECTEDCOMPRESSEDDIARYPAGE);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto ChangeEnd;
	}
	// We have to decompress the page.
	//................................
	lpDiaryPage1 = AllocateMemory(Msghdr.dwMsgSize);
	if (!lpDiaryPage1)
	{
		goto ChangeEnd;
	}
	// Set the start of the compressed data.
	//......................................
	lpDiaryPageDup =(lpDiaryPage + sizeof(MSG_HEADER));

	ZeroMemory(&z,sizeof(z_stream));

	z.next_in = lpDiaryPageDup;
	z.next_out = lpDiaryPage1;
	z.avail_in = Msghdr.dwCompressedMsgSize;
	z.avail_out = Msghdr.dwMsgSize;

	// Initialize the check crc32 value.
	//..................................
	dwCheckCrc32 = crc32(0L,Z_NULL,0);

	iError = inflateInit(&z);
	if (iError != Z_OK)
	{
		ZlibError((LPBYTE)&szMyDiary,iError,IDS_INFLATEINIT);
		goto ChangeEnd;
	}
	bInit = TRUE;

	iError = inflate(&z,Z_FINISH);
	if (iError < 0)
	{
		ZlibError((LPBYTE)&szMyDiary,iError,IDS_INFLATE);
		goto ChangeEnd;
	}
	if (iError != Z_STREAM_END)
	{
		ZlibError((LPBYTE)&szMyDiary,Z_DATA_ERROR,IDS_INFLATE);
		goto ChangeEnd;
	}
	// Number of bytes to stream into the rtf control.
	//................................................
	dwPageCount = z.total_out;

	// Get the final crc32 check value.
	//.................................
	dwCheckCrc32 = crc32(dwCheckCrc32,lpDiaryPage1,z.total_out);

	if (dwCheckCrc32 != Msghdr.dwMsgCrc32)
	{
		SetLastError(IDS_DIARYPAGECRC32NOGOOD);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_COMPARE,MB_OK);
		goto ChangeEnd;
	}
	iError = inflateEnd(&z);
	if (iError != Z_OK)
	{
		ZlibError((LPBYTE)&szMyDiary,iError,IDS_INFLATEEND);
		goto ChangeEnd;
	}
	bInit = FALSE;

	// We have good data. We can erase the old page and display
	// the new one.
	//.........................................................
	ClearDiaryPage(hDlg);
	bNotChanged = FALSE;

	// Display the create and modified data and time.
	//...............................................
	LoadString(hInst,IDS_DIARYCREATED,(LPTSTR)&szBuffer1,sizeof(szBuffer1));
	TimestampToDateTime(DiaryPage.uliDateCreated.QuadPart,&stLocal);
	GetDateFormat(LOCALE_USER_DEFAULT,0,&stLocal,"ddd',' dd MMM yyyy",
				  szBuffer2,sizeof(szBuffer2));
	GetTimeFormat(LOCALE_USER_DEFAULT,0,&stLocal,(LPCTSTR)lpFormat[21],
				 (LPTSTR)&szBuffer3,sizeof(szBuffer3));
	StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szBuffer1,&szBuffer2,
					&szBuffer3);
	SetDlgItemText(hDlg,IDC_PAGECREATED,(LPCTSTR)&szBuffer);

	if (DiaryPage.uliLastModified.QuadPart != 0)
	{
		LoadString(hInst,IDS_DIARYMODIFIED,(LPTSTR)&szBuffer1,sizeof(szBuffer1));
		TimestampToDateTime(DiaryPage.uliLastModified.QuadPart,&stLocal);
		GetDateFormat(LOCALE_USER_DEFAULT,0,&stLocal,"ddd',' dd MMM yyyy",
					  szBuffer2,sizeof(szBuffer2));
		GetTimeFormat(LOCALE_USER_DEFAULT,0,&stLocal,(LPCTSTR)lpFormat[21],
					 (LPTSTR)&szBuffer3,sizeof(szBuffer3));
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szBuffer1,&szBuffer2,
						&szBuffer3);
		SetDlgItemText(hDlg,IDC_PAGEMODIFIED,(LPCTSTR)&szBuffer);
	}
	else
	{
		SetDlgItemText(hDlg,IDC_PAGEMODIFIED,lpszNullString);
	}
	SetDlgItemText(hDlg,IDC_KW1,(LPCTSTR)&DiaryPage.kw1);
	SetDlgItemText(hDlg,IDC_KW2,(LPCTSTR)&DiaryPage.kw2);
	SetDlgItemText(hDlg,IDC_KW3,(LPCTSTR)&DiaryPage.kw3);
	SetDlgItemText(hDlg,IDC_KW4,(LPCTSTR)&DiaryPage.kw4);
	SetDlgItemText(hDlg,IDC_KW5,(LPCTSTR)&DiaryPage.kw5);
	SetDlgItemText(hDlg,IDC_KW6,(LPCTSTR)&DiaryPage.kw6);

	// Set the modify flag to not modified.
	//.....................................
	SendDlgItemMessage(hDlg,IDC_KW1,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW2,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW3,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW4,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW5,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW6,EM_SETMODIFY,FALSE,0);

	SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETBKGNDCOLOR,0,
					  (LPARAM)(COLORREF)DiaryPage.crBkg);
	crOleBkg = DiaryPage.crBkg;

	lpOutBuffer = lpDiaryPage1;

	eStream.dwCookie = (DWORD)lpOutBuffer;
	eStream.dwError = 0;
	eStream.pfnCallback = EditStreamPageInCallback;

	SendMessage(GetDlgItem(hDlg,IDC_DIARYNOTE),EM_STREAMIN,(WPARAM)SF_RTF,(LPARAM)&eStream);

	// Get the result of the operation.
	//.................................
	if (eStream.dwError)
	{
		SetLastError(IDS_RTFSTREAMINERROR);
		ErrorProcedure(lpszRTF,IDS_RTFSTREAMIN,MB_OK);
	}
	SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);

	bNewPage = FALSE;
	EnableWindow(GetDlgItem(hDlg,IDC_NEWPAGE),TRUE);
	CopyMemory(&PrevDiaryEntry,&DiaryEntry,sizeof(DIARYENTRY));

	// Display the delete state and set the buttons.
	//..............................................
	if (DiaryPage.bEdited)
	{
		SetDlgItemText(hDlg,IDC_MARK,(LPCTSTR)&szDeletePage);
		EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),FALSE);
		EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),TRUE);
	}
	else
	{
		SetDlgItemText(hDlg,IDC_MARK,lpszNullString);
		EnableWindow(GetDlgItem(hDlg,IDC_PAGEDELETE),TRUE);
		EnableWindow(GetDlgItem(hDlg,IDC_PAGEUNDELETE),FALSE);
	}

	ChangeEnd:

	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	EmptyTheMessageQue();

	if (bInit)
	{
		iError = inflateEnd(&z);
		if (iError != Z_OK)
		{
			ZlibError((LPBYTE)&szMyDiary,iError,IDS_INFLATEEND);
		}
	}
	if (lpDiaryPage)
	{
		ZeroMemory(lpDiaryPage,DiaryPage.dwDataLength);
		DeallocateMemory(lpDiaryPage);
	}
	if (lpDiaryPage1)
	{
		ZeroMemory(lpDiaryPage1,Msghdr.dwCompressedMsgSize);
		DeallocateMemory(lpDiaryPage1);
	}
	// Reset the status bar to ready or the name of the key rings.
	//............................................................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,szOutBuffer,sizeof(szOutBuffer));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szOutBuffer);
	}
	if (bNotChanged)
	{
		CopyMemory(&DiaryPage,&SavedDiaryPage,sizeof(DIARYPAGE));
	}
}

// Callback function for streaming the data into the rich text window.
//....................................................................
DWORD CALLBACK EditStreamPageInCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb)
{
	DWORD		dwBytesToXfer;
	DWORD		dwcb;

	dwcb = (DWORD)cb;

	if (dwPageCount != 0)
	{
		if (dwPageCount < dwcb)
		{
			dwBytesToXfer = dwPageCount;
			dwPageCount = 0;
		}
		else
		{
			dwBytesToXfer = dwcb;
			dwPageCount -= dwcb;
		}
		CopyMemory(pbBuff,lpOutBuffer,dwBytesToXfer);

		lpOutBuffer += dwBytesToXfer;
		*pcb = dwBytesToXfer;
	}
	else
	{
		*pcb = 0;
	}
	return(0);
}

// Set the local date and time for the diary page.
//................................................
VOID SetLocalDateTime(HWND hDlg)
{
	TCHAR					szBuffer[128];
	TCHAR					szBuffer1[128];
	TCHAR					szBuffer2[128];
	TCHAR					szBuffer3[128];
	SYSTEMTIME				stLocal;

	LoadString(hInst,IDS_DIARYCREATED,(LPTSTR)&szBuffer1,sizeof(szBuffer1));
	NewDiaryPage.uliDateCreated.QuadPart = GetTimestamp(FALSE);
	TimestampToDateTime(NewDiaryPage.uliDateCreated.QuadPart,&stLocal);
	GetDateFormat(LOCALE_USER_DEFAULT,0,&stLocal,"ddd',' dd MMM yyyy",
				  szBuffer2,sizeof(szBuffer2));
	GetTimeFormat(LOCALE_USER_DEFAULT,0,&stLocal,(LPCTSTR)lpFormat[21],
				 (LPTSTR)&szBuffer3,sizeof(szBuffer3));
	StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szBuffer1,&szBuffer2,
					&szBuffer3);
	SetDlgItemText(hDlg,IDC_PAGECREATED,(LPCTSTR)&szBuffer);
}

// Check to see if the page has been modified.
//............................................
BOOL PageModified(HWND hDlg)
{
	DWORD		dwDP, dwKw1, dwKw2, dwKw3, dwKw4, dwKw5, dwKw6;
	BOOL		bModified = FALSE;

	dwDP = SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_GETMODIFY,0,0);
	dwKw1 = SendDlgItemMessage(hDlg,IDC_KW1,EM_GETMODIFY,0,0);
	dwKw2 = SendDlgItemMessage(hDlg,IDC_KW2,EM_GETMODIFY,0,0);
	dwKw3 = SendDlgItemMessage(hDlg,IDC_KW3,EM_GETMODIFY,0,0);
	dwKw4 = SendDlgItemMessage(hDlg,IDC_KW4,EM_GETMODIFY,0,0);
	dwKw5 = SendDlgItemMessage(hDlg,IDC_KW5,EM_GETMODIFY,0,0);
	dwKw6 = SendDlgItemMessage(hDlg,IDC_KW6,EM_GETMODIFY,0,0);

	if (dwDP || dwKw1 || dwKw2 || dwKw3 || dwKw4 || dwKw5 || dwKw6)
	{
		bModified = TRUE;
	}
	return(bModified);
}

// Clear a diary page.
//....................
VOID ClearDiaryPage(HWND hDlg)
{
	SetDlgItemText(hDlg,IDC_DIARYNOTE,lpszNullString);
	SetDlgItemText(hDlg,IDC_KW1,lpszNullString);
	SetDlgItemText(hDlg,IDC_KW2,lpszNullString);
	SetDlgItemText(hDlg,IDC_KW3,lpszNullString);
	SetDlgItemText(hDlg,IDC_KW4,lpszNullString);
	SetDlgItemText(hDlg,IDC_KW5,lpszNullString);
	SetDlgItemText(hDlg,IDC_KW6,lpszNullString);

	SendDlgItemMessage(hDlg,IDC_DIARYNOTE,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW1,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW2,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW3,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW4,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW5,EM_SETMODIFY,FALSE,0);
	SendDlgItemMessage(hDlg,IDC_KW6,EM_SETMODIFY,FALSE,0);

	SetFocus(GetDlgItem(hDlg,IDC_DIARYNOTE));

	EmptyTheMessageQue();
}

// Create tree view. Called when you initialize the control.
//..........................................................
BOOL CreateTreeView()
{
	TVINSERTSTRUCT		tvins;
	TVITEMEX			tvi;
	BOOL				bError = TRUE;

	// We first have to create the default entries.
	// Clear the default handles.
	//.............................................
	hRoot = 0;
	hByDate = 0;
	hByKeyword = 0;
	
	// Create the root entry.
	//.......................
	tvi.mask = uiBook;
	tvi.pszText = (LPTSTR)&DiaryEnd.Owner;
	tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEnd.Owner);
	tvi.iImage = BOOKCLOSEDIMAGE;
	tvi.iSelectedImage = BOOKCLOSEDIMAGE;
	tvi.lParam = (LPARAM)0xffffffff;
	tvi.cChildren = 1;

	tvins.hParent = TVI_ROOT;
	tvins.hInsertAfter = TVI_ROOT;
	tvins.itemex = tvi;
	hRoot = TreeView_InsertItem(hTreeView,&tvins);
	hPrevItem = hRoot;
	if (hPrevItem == NULL)
	{
		SetLastError(IDS_TREEVIEWINSERTERROR);
		ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
		goto CreateTvEnd;
	}
	// Now go into a loop and process the index file.
	//...............................................
	bError = AddItemsToTreeView();

	CreateTvEnd:

	EmptyTheMessageQue();

	return(bError);
}

// Add items to the tree view control.
//....................................
BOOL AddItemsToTreeView()
{
	ULARGE_INTEGER		uli;
	TVINSERTSTRUCT		tvins;
	TVITEMEX			tvi;
	BOOL				bError = TRUE;
	BOOL				bResult;
	DWORD				dwBytesRead;
	DWORD				dwEntry = 0;
	int					iCompareResult;
	DIARYENTRY			de;
	HTREEITEM			hParent;
	HTREEITEM			hPrevious;
	HTREEITEM			hThisItem;

	if (!dwIndexEntries)
	{
		bError = FALSE;
		goto AddEnd;
	}
	// Signal TVN_SELCHAGNING that we are building a new tree.
	//........................................................
	bBuildingTree = TRUE;

	if (hByKeyword)
	{
		bResult = TreeView_DeleteItem(hTreeView,hByKeyword);
		if (!bResult)
		{
			SetLastError(IDS_TREEVIEWINSERTERROR);
			ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
			goto AddEnd;
		}
		EmptyTheMessageQue();
		hByKeyword = 0;
	}
	
	if (hByDate)
	{
		bResult = TreeView_DeleteItem(hTreeView,hByDate);
		if (!bResult)
		{
			SetLastError(IDS_TREEVIEWINSERTERROR);
			ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
			goto AddEnd;
		}
		EmptyTheMessageQue();
		hByDate = 0;
	}

	hPrevYear = 0;
	hPrevMonth = 0;
	hPrevKeyword = 0;
	ZeroMemory(&de,sizeof(DIARYENTRY));

	// We have entries in the index file.
	//...................................
	uli.QuadPart = 0;
	uli.QuadPart = SetMyFilePointer((LPTSTR)&szIndexTemp,hIndexTemp,uli.QuadPart,FILE_BEGIN);
	if (uli.QuadPart == -1)
	{
		goto AddEnd;
	}
	// Loop through the index file.
	//.............................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,sizeof(DIARYENTRY),
							 &dwBytesRead,NULL);
		if (!bResult)
		{
			goto AddEnd;
		}
		// Check for eof.
		//...............
		if (dwBytesRead == 0)
		{
			break;
		}
		// Handle the date entries.
		//........................
		if (DiaryEntry.Type_Entry == 1)
		{
			// If we do not have a By Date entry do it now.
			//.............................................
			if (!hByDate)
			{
				tvi.mask = uiBook;
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = (LPARAM)0xffffffff;
				tvi.cChildren = 1;
				tvi.pszText = (LPTSTR)&szByDate;
				tvi.cchTextMax = lstrlen((LPCTSTR)&szByDate);

				tvins.hParent = hRoot;
				tvins.hInsertAfter = hRoot;
				tvins.itemex = tvi;
				hByDate = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hByDate;
				if (hPrevItem == NULL)
				{
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
			}
			// If we are just creating the tree view, we have to create
			// the first year and month entries.
			//.........................................................
			if (hPrevYear == 0)
			{	
				tvi.mask = uiBook;
				tvi.pszText = (LPTSTR)&DiaryEntry.Year;
				tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEntry.Year);
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = 0xffffffff;
				tvi.cChildren = 1;
				tvins.hParent = hByDate;
				tvins.hInsertAfter = hByDate;
				tvins.itemex = tvi;
				hPrevYear = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevYear;
				if (hPrevItem == NULL)
				{	
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				// Now do the month.
				//..................
				tvi.pszText = (LPTSTR)lpMonths[DiaryEntry.st.wMonth];
				tvi.cchTextMax = lstrlen((LPCTSTR)lpMonths[DiaryEntry.st.wMonth]);
				tvins.hParent = hPrevYear;
				tvins.hInsertAfter = hPrevItem;
				tvins.itemex = tvi;
				hPrevMonth = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevMonth;
				if (hPrevItem == NULL)
				{
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				CopyMemory(&de,&DiaryEntry,sizeof(DIARYENTRY));
				hParent = hPrevMonth;
				hPrevious = hPrevItem;
				hThisItem = hPrevItem;
			}
			// First check to see if we have a new year and or month.
			//.......................................................
			if (DiaryEntry.st.wYear != de.st.wYear)
			{
				// We have to create a new year and month.
				//........................................
				tvi.mask = uiBook;
				tvi.pszText = (LPTSTR)&DiaryEntry.Year;
				tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEntry.Year);
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = 0xffffffff;
				tvi.cChildren = 1;
				tvins.hParent = hByDate;
				tvins.hInsertAfter = hPrevItem;
				tvins.itemex = tvi;
				hPrevYear = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevYear;
				if (hPrevItem == NULL)
				{	
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				// Now to the month.
				//..................
				tvi.pszText = (LPTSTR)lpMonths[DiaryEntry.st.wMonth];
				tvi.cchTextMax = lstrlen((LPCTSTR)lpMonths[DiaryEntry.st.wMonth]);
				tvins.hParent = hPrevYear;
				tvins.hInsertAfter = hPrevItem;
				tvins.itemex = tvi;
				hPrevMonth = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevMonth;
				if (hPrevItem == NULL)
				{
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				hParent = hPrevMonth;
				hPrevious = hPrevItem;
				hThisItem = hPrevItem;
			}
			else if (DiaryEntry.st.wMonth != de.st.wMonth)
			{
				// We have a new month.
				//.....................
				tvi.mask = uiBook;
				tvi.pszText = (LPTSTR)lpMonths[DiaryEntry.st.wMonth];
				tvi.cchTextMax = lstrlen((LPCTSTR)lpMonths[DiaryEntry.st.wMonth]);
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = 0xffffffff;
				tvi.cChildren = 1;
				tvins.hParent = hPrevYear;
				tvins.hInsertAfter = hPrevItem;
				tvins.itemex = tvi;
				hPrevMonth = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevMonth;
				if (hPrevItem == NULL)
				{
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				hParent = hPrevMonth;
				hPrevious = hPrevItem;
				hThisItem = hPrevItem;
			}
			// Now add the actual item.
			//.........................
			tvi.mask = uiPage;
			tvi.pszText = (LPTSTR)&DiaryEntry.Date_Time;
			tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEntry.Date_Time);
			tvi.iImage = PAGEIMAGE;
			tvi.iSelectedImage = PAGEIMAGE;
			tvi.lParam = dwEntry;
			tvi.cChildren = 0;
			tvins.hParent = hParent;
			tvins.hInsertAfter = hThisItem;
			tvins.itemex = tvi;
			hThisItem = TreeView_InsertItem(hTreeView,&tvins);
			hPrevItem = hThisItem;
			if (hPrevItem == NULL)
			{
				SetLastError(IDS_TREEVIEWINSERTERROR);
				ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
				goto AddEnd;
			}
			EmptyTheMessageQue();

			// Increment the enty number for the next item.
			//.............................................
			dwEntry++;
		}
		else
		{
			// If we do not have a By Keyword entry do it now.
			//................................................
			if (!hByKeyword)
			{
				tvi.mask = uiBook;
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = (LPARAM)0xffffffff;
				tvi.cChildren = 1;
				tvi.pszText = (LPTSTR)&szByKeyword;
				tvi.cchTextMax = lstrlen((LPCTSTR)&szByKeyword);

				tvins.hParent = hRoot;
				tvins.hInsertAfter = hPrevItem;
				tvins.itemex = tvi;
				hByKeyword = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hByKeyword;
				if (hPrevItem == NULL)
				{
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
			}
			if (hPrevKeyword == 0)
			{
				// We have to create the first keyword entry.
				//...........................................
				tvi.mask = uiBook;
				tvi.pszText = (LPTSTR)&DiaryEntry.KeyWord;
				tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEntry.KeyWord);
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = 0xffffffff;
				tvi.cChildren = 1;
				tvins.hParent = hByKeyword;
				tvins.hInsertAfter = hByKeyword;
				tvins.itemex = tvi;
				hPrevKeyword = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevKeyword;
				if (hPrevItem == NULL)
				{	
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				CopyMemory(&de,&DiaryEntry,sizeof(DIARYENTRY));
				hParent = hPrevKeyword;
				hPrevious = hPrevItem;
				hThisItem = hPrevItem;
			}
			// Make an entry for this keyword entry. First check to see
			// if we have a new keyword or not.
			//.........................................................
			iCompareResult = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
										  (LPCTSTR)&DiaryEntry.KeyWord,-1,
										  (LPCTSTR)&de.KeyWord,-1);
			if (iCompareResult != CSTR_EQUAL)
			{
				// We have to make a new keyword entry.
				//.....................................
				tvi.mask = uiBook;
				tvi.pszText = (LPTSTR)&DiaryEntry.KeyWord;
				tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEntry.KeyWord);
				tvi.iImage = BOOKCLOSEDIMAGE;
				tvi.iSelectedImage = BOOKCLOSEDIMAGE;
				tvi.lParam = 0xffffffff;
				tvi.cChildren = 1;
				tvins.hParent = hByKeyword;
				tvins.hInsertAfter = hPrevItem;
				tvins.itemex = tvi;
				hPrevKeyword = TreeView_InsertItem(hTreeView,&tvins);
				hPrevItem = hPrevKeyword;
				if (hPrevItem == NULL)
				{	
					SetLastError(IDS_TREEVIEWINSERTERROR);
					ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
					goto AddEnd;
				}
				EmptyTheMessageQue();

				hParent = hPrevKeyword;
				hPrevious = hPrevItem;
				hThisItem = hPrevItem;
			}
			// Now make the actual entry.
			//...........................
			tvi.mask = uiPage;
			tvi.pszText = (LPTSTR)&DiaryEntry.Date_Time;
			tvi.cchTextMax = lstrlen((LPCTSTR)&DiaryEntry.Date_Time);
			tvi.iImage = PAGEIMAGE;
			tvi.iSelectedImage = PAGEIMAGE;
			tvi.lParam = dwEntry;
			tvi.cChildren = 0;
			tvins.hParent = hParent;
			tvins.hInsertAfter = hPrevious;
			tvins.itemex = tvi;
			hThisItem = TreeView_InsertItem(hTreeView,&tvins);
			hPrevItem = hThisItem;
			if (hPrevItem == NULL)
			{	
				SetLastError(IDS_TREEVIEWINSERTERROR);
				ErrorProcedure((LPTSTR)&szTreeViewControl,IDS_INSERTTV,MB_OK);
				goto AddEnd;
			}
			EmptyTheMessageQue();

			// Increment the entry number.
			//............................
			dwEntry++;
		}
		CopyMemory(&de,&DiaryEntry,sizeof(DIARYENTRY));
		uli.QuadPart += sizeof(DIARYENTRY);
	}
	// No errors.
	//...........
	bError = FALSE;

	// Lets expand a few nodes of the tree.
	//.....................................
	TreeView_Expand(hTreeView,hRoot,TVE_EXPAND);
	TreeView_Expand(hTreeView,hByKeyword,TVE_EXPAND);
	EmptyTheMessageQue();

	AddEnd:

	bBuildingTree = FALSE;

	EmptyTheMessageQue();

	return(bError);
}

// Create and sort the diary index file.
//......................................
BOOL CreateDiaryIndexFile()
{
	LARGE_INTEGER	li;
	DWORD			dwBytesRead;
	BOOL			bError = TRUE;
	BOOL			bResult;
	int				iCompareResult;
	DWORD			dwBytesWritten;
	DWORD			dwPages;
	DWORD			dwKeywords;
	TCHAR			szBuffer[80];
	TCHAR			szBuffer1[80];
	TCHAR			szBuffer2[80];

	// We will recount these.
	//.......................
	dwIndexEntries = 0;
	dwPages = 0;
	dwKeywords = 0;

	// Create and sort the index file. Reset to the first record.
	//...........................................................
	li.QuadPart = sizeof(DIARYHDR);
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto CreateEnd;
	}
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryPage,sizeof(DIARYPAGE),
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto CreateEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Make sure we have a valid diary page.
		//......................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&DiaryPage.id,
									   4,(LPCTSTR)&szDiaryId,4);
		if (iCompareResult != CSTR_EQUAL)
		{
			SetLastError(IDS_INVALIDDIARYPAGE);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto CreateEnd;
		}
		ZeroMemory(&DiaryEntry,sizeof(DIARYENTRY));
		ZeroMemory(&szBuffer,sizeof(szBuffer));
			
		// Create the date entry for this page in the diary.
		//..................................................
		DiaryEntry.uliOffset.QuadPart = li.QuadPart;
		DiaryEntry.Type_Entry = 1;
		CopyMemory(&DiaryEntry.KeyWord,&szCharA,sizeof(szCharA));

		// Adjust the file location pointer.
		//..................................
		li.QuadPart += sizeof(DIARYPAGE);

		// Convert the date and time for this entry.
		//..........................................
		TimestampToDateTime(DiaryPage.uliDateCreated.QuadPart,&DiaryEntry.st);

		// Get the date/time stamp in proper order for sorting.
		//.....................................................
		DiaryEntry.dwCreated[0] = DiaryPage.uliDateCreated.HighPart;
		DiaryEntry.dwCreated[1] = DiaryPage.uliDateCreated.LowPart;

		// Convert the date and time to a string format.
		//..............................................
		GetDateFormat(LOCALE_USER_DEFAULT,0,&DiaryEntry.st,"ddd',' dd MMM yyyy",szBuffer1,
				      sizeof(szBuffer1));
		StringCbPrintf((LPTSTR)&szBuffer2,sizeof(szBuffer2),szTime,DiaryEntry.st.wHour,
						&TimeSep,DiaryEntry.st.wMinute,&TimeSep,DiaryEntry.st.wSecond);
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szDateTimeFmt,&szBuffer1,
						&szBuffer2);
		CopyMemory(&DiaryEntry.Date_Time,&szBuffer,sizeof(DiaryEntry.Date_Time));

		// Get the year as four digits.
		//.............................
		StringCbPrintf((LPTSTR)&DiaryEntry.Year,sizeof(DiaryEntry.Year),TEXT("%u"),
						DiaryEntry.st.wYear);

		// Write the entry to disk.
		//.........................
		bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,sizeof(DIARYENTRY),
							   &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto CreateEnd;
		}
		dwIndexEntries++;
		dwPages++;

		// Now process the entries for the keywords.
		//..........................................
		if (*DiaryPage.kw1 != 0)
		{
			DiaryEntry.Type_Entry = 2;
			CopyMemory(&DiaryEntry.KeyWord,&DiaryPage.kw1,sizeof(DiaryEntry.KeyWord));

			// Write the entry to disk.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
								   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto CreateEnd;
			}
			dwIndexEntries++;
			dwKeywords++;
		}
		if (*DiaryPage.kw2 != 0)
		{
			DiaryEntry.Type_Entry = 2;
			CopyMemory(&DiaryEntry.KeyWord,&DiaryPage.kw2,sizeof(DiaryEntry.KeyWord));

			// Write the entry to disk.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
								   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto CreateEnd;
			}
			dwIndexEntries++;
			dwKeywords++;
		}
		if (*DiaryPage.kw3 != 0)
		{
			DiaryEntry.Type_Entry = 2;
			CopyMemory(&DiaryEntry.KeyWord,&DiaryPage.kw3,sizeof(DiaryEntry.KeyWord));

			// Write the entry to disk.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
								   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto CreateEnd;
			}
			dwIndexEntries++;
			dwKeywords++;
		}
		if (*DiaryPage.kw4 != 0)
		{
			DiaryEntry.Type_Entry = 2;
			CopyMemory(&DiaryEntry.KeyWord,&DiaryPage.kw4,sizeof(DiaryEntry.KeyWord));

			// Write the entry to disk.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
								   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto CreateEnd;
			}
			dwIndexEntries++;
			dwKeywords++;
		}
		if (*DiaryPage.kw5 != 0)
		{
			DiaryEntry.Type_Entry = 2;
			CopyMemory(&DiaryEntry.KeyWord,&DiaryPage.kw5,sizeof(DiaryEntry.KeyWord));

			// Write the entry to disk.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
								   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto CreateEnd;
			}
			dwIndexEntries++;
			dwKeywords++;
		}
		if (*DiaryPage.kw6 != 0)
		{
			DiaryEntry.Type_Entry = 2;
			CopyMemory(&DiaryEntry.KeyWord,&DiaryPage.kw6,sizeof(DiaryEntry.KeyWord));

			// Write the entry to disk.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szIndexTemp,hIndexTemp,&DiaryEntry,
								   sizeof(DIARYENTRY),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto CreateEnd;
			}
			dwIndexEntries++;
			dwKeywords++;
		}
		// Now find the next entry past the encrypted page.
		//.................................................
		li.QuadPart += DiaryPage.dwDataLength;

		li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
		if (li.QuadPart == -1)
		{
			goto CreateEnd;
		}
	}
	// Sort the just created index file.
	//..................................
	bResult = SortMyFile((LPTSTR)&szIndexTemp,hIndexTemp,0,&DiarySort,ASCENDING);

	if (bResult)
	{
		bError = FALSE;
		DiaryEnd.dwPages = dwPages;
		DiaryEnd.dwKeywords = dwKeywords;
	}
	CreateEnd:

	dwJrlPages = dwPages;
	dwJrlKeywords = dwKeywords;

	return(bError);
}

// CALLBACK procedure for Admin Code sign in. We have found we are on a
// different computer.
//.....................................................................
LRESULT CALLBACK AdminCodeSignInProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	int			iResult;
	LPBYTE		lpDiaryName;
	UINT		uCheck;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the passwords.
			//.......................................
			SendDlgItemMessage(hDlg,IDC_ADMINCODEDIARY,EM_SETLIMITTEXT,(WPARAM)16,0);

			lpDiaryName = PathFindFileName((LPCTSTR)&szMyDiary);
			SetDlgItemText(hDlg,IDC_DIARY,(LPCTSTR)lpDiaryName);

			ZeroMemory(&szAdminCode,sizeof(szAdminCode));
			ZeroMemory(&szTemp,sizeof(szTemp));
			
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEDIARY));

			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Get the password.
					//..................
					GetDlgItemText(hDlg,IDC_ADMINCODEDIARY,(LPTSTR)&szTemp,sizeof(szTemp));
					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp);

					if (dwLengthPP1 == 0 || dwLengthPP1 > 16)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_ADMINCODEBAD,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						SetDlgItemText(hDlg,IDC_ADMINCODEDIARY,lpszNullString);
						ZeroMemory(&szTemp,sizeof(szTemp));
						ZeroMemory(&szAdminCode,sizeof(szAdminCode));
						SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEDIARY));
						break;
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp[dwV] != DEFAULT_CHAR)
							{
								szAdminCode[dwV] = szTemp[dwV];
							}
						}
					}
					// See if the admin code is correct.
					//..................................
					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&DiaryEnd.szCode,-1,
										   (LPCTSTR)&szAdminCode,-1);

					if (iResult != CSTR_EQUAL)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_ADMINCODEBAD,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						SetDlgItemText(hDlg,IDC_ADMINCODEDIARY,lpszNullString);
						SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEDIARY));
						break;
					}
					ZeroMemory(&szTemp,sizeof(szTemp));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_MAKEPERMANENT:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_MAKEPERMANENT);
					if (uCheck == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_MAKEPERMANENT,BST_UNCHECKED);
						bMakePermanent = FALSE;
					}
					else
					{
						CheckDlgButton(hDlg,IDC_MAKEPERMANENT,BST_CHECKED);
						bMakePermanent = TRUE;
					}
				}
				break;

				case IDC_PPTSCGTEXT:
				{
					// Popup the virtual keyboard.
					//............................
					VirtualKeyboard(hDlg,IDC_ADMINCODEDIARY,(LPBYTE)&szAdminCode,
									sizeof(szAdminCode));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEDIARY));
				}
				break;

				case IDC_PPTSCGCLEAR:
				{
					SetDlgItemText(hDlg,IDC_ADMINCODEDIARY,lpszNullString);
					ZeroMemory(&szAdminCode,sizeof(szAdminCode));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEDIARY));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_ADMINCODEDIARY,lpszNullString);
					ZeroMemory(&szAdminCode,sizeof(szAdminCode));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for signing into your diary.
//................................................
LRESULT CALLBACK DiarySignInProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	LPBYTE		lpDiaryName;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the passwords.
			//.......................................
			SendDlgItemMessage(hDlg,IDC_PPTDIARY,EM_SETLIMITTEXT,(WPARAM) 255,0);

			lpDiaryName = PathFindFileName((LPCTSTR)&szMyDiary);
			SetDlgItemText(hDlg,IDC_DIARY,(LPCTSTR)lpDiaryName);

			ZeroMemory(&szJrlPassWord,sizeof(szJrlPassWord));
			ZeroMemory(&szTemp,sizeof(szTemp));
			
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_PPTDIARY));

			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Get the password.
					//..................
					GetDlgItemText(hDlg,IDC_PPTDIARY,(LPTSTR)&szTemp,MAX_PATH);
					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp);

					if (dwLengthPP1 < 6 || dwLengthPP1 > 255)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNINTSCG,
									   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
									   MB_ICONEXCLAMATION,0);
						SetDlgItemText(hDlg,IDC_PPTDIARY,lpszNullString);
						ZeroMemory(&szTemp,sizeof(szTemp));
						ZeroMemory(&szJrlPassWord,sizeof(szJrlPassWord));
						SetFocus(GetDlgItem(hDlg,IDC_PPTDIARY));
						break;
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp[dwV] != DEFAULT_CHAR)
							{
								szJrlPassWord[dwV] = szTemp[dwV];
							}
						}
					}
					ZeroMemory(&szTemp,sizeof(szTemp));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_PPTSCGTEXT:
				{
					// Popup the virtual keyboard.
					//............................
					VirtualKeyboard(hDlg,IDC_PPTDIARY,(LPBYTE)&szJrlPassWord,
									sizeof(szJrlPassWord));
					SetFocus(GetDlgItem(hDlg,IDC_PPTDIARY));
				}
				break;

				case IDC_PPTSCGCLEAR:
				{
					SetDlgItemText(hDlg,IDC_PPTDIARY,lpszNullString);
					ZeroMemory(&szJrlPassWord,sizeof(szJrlPassWord));
					SetFocus(GetDlgItem(hDlg,IDC_PPTDIARY));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_PPTDIARY,lpszNullString);
					ZeroMemory(&szJrlPassWord,sizeof(szJrlPassWord));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Change the pass phrase for a top secret diary.
//...............................................
VOID ChangeDiaryPassPhrase()
{
	OPENFILENAME	ofn;
	LARGE_INTEGER	li;
	DWORD			dwOldHelpTopic;
	BOOL			bResult;
	BOOL			bCancelled = TRUE;
	BOOL			bDeleteTemp = FALSE;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	int				iCompareResult;
	int				iDlgResult;
	DIARYEND		Diary_End;
	LPBYTE			lpJrlName;
	TCHAR			szBuffer1[512];
	TCHAR			szBuffer2[256];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_CHANGE_DIARY_PP);

	hMyDiary = 0;
	bDiaryModified = FALSE;
	bDiaryError = TRUE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_DIARYFILES);

	// Get diary if not from command line or a new diary.
	//...................................................
	while(TRUE)
	{
		ZeroMemory(&szMyDiary,MAX_PATH);

		ofn.lpstrFile = szMyDiary;	
		ofn.nMaxFile = MAX_PATH;
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("Top Secret Journal Files [.jrl]\0*.jrl\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Open a Top Secret Journal");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
				     OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_SHOWHELP);
		ofn.lpstrDefExt = NULL;
		ofn.lpfnHook = MyOFNHookProc;
		
		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto ChangeEnd;
		}
		SaveDirName((LPBYTE)&szMyDiary,SAVE_SOURCE | SAVE_DIARYFILES,TRUE);

		lpJrlName = PathFindFileName((LPCTSTR)&szMyDiary);

		// Create a backup of the diary in case anything goes wrong.
		//..........................................................
		CopyMemory(&szDiaryTemp,&szMyDiary,MAX_PATH);
		PathRemoveFileSpec((LPTSTR)&szDiaryTemp);
		PathAddBackslash((LPTSTR)&szDiaryTemp);
		StringCbCatEx((LPTSTR)&szDiaryTemp,sizeof(szDiaryTemp),(LPCTSTR)&szTempDiary,NULL,
					   NULL,dwStringSafeFlag);
		bResult = CopyFile((LPCTSTR)&szMyDiary,(LPCTSTR)&szDiaryTemp,FALSE);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_COPYFILE,MB_OK);
			goto ChangeEnd;
		}
		bDeleteTemp = TRUE;

		// Open the file and make sure it has a valid header.
		//...................................................
		hMyDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,0,
								 NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hMyDiary)
		{
			goto ChangeEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryHdr,sizeof(DiaryHdr),
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto ChangeEnd;
		}
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&DiaryHdr,
									   sizeof(DiaryHdr),(LPCTSTR)&szDiaryId,dwBytesRead);
		if (iCompareResult == CSTR_EQUAL)
		{
			// Read in the DIARYEND structure and check it out.
			//.................................................
			li.QuadPart = 0;
			li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_END);
			if (li.QuadPart == -1)
			{
				goto ChangeEnd;
			}
			li.QuadPart -= sizeof(DIARYEND);
			if (li.QuadPart < sizeof(DIARYHDR))
			{
				SetLastError(IDS_INVALIDDIARY);
				ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			}
			else
			{
				break;
			}
		}
		bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
		if (!bResult)
		{
			goto ChangeEnd;
		}
		hMyDiary = 0;
	}
	// Read in the DIARYEND structure.
	//................................
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto ChangeEnd;
	}
	bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryEnd,sizeof(DIARYEND),
						  &dwBytesRead,NULL);
	if (!bResult)
	{
		goto ChangeEnd;
	}
	while(TRUE)
	{
		// Get the password to decrypt the DIARYEND structure.
		//....................................................
		iDlgResult = DialogBox(hInst,TEXT("DIARYSIGNIN"),hMainWindow,(DLGPROC)DiarySignInProc);
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto ChangeEnd;
		}
		if (iDlgResult == IDCANCEL)
		{
			goto ChangeEnd;
		}
		CopyMemory(&Diary_End,&DiaryEnd,sizeof(DIARYEND));

		// We have the password.
		//......................
		DecipherSecretComponents((LPBYTE)&szJrlPassWord,(LPBYTE)&Diary_End.id,
								  lstrlen((LPCTSTR)&szJrlPassWord),sizeof(DIARYEND)-CFB_LENGTH);

		// See if the id field is equal to tscd.
		//......................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&Diary_End.id,4,
									  (LPCTSTR)&szDiaryId,4);

		if (iCompareResult != CSTR_EQUAL)
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSIGNINDIARY,
						   MB_ICONEXCLAMATION | MB_OK | MB_HELP,
						   MB_ICONEXCLAMATION,0);
			continue;
		}
		CopyMemory(&DiaryEnd,&Diary_End,sizeof(DIARYEND));
		break;
	}
	// Set the end of file to get rid of the DIARYEND structure.
	// Makes it easier to append new pages.
	//..........................................................
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto ChangeEnd;
	}
	bResult = SetEndOfFile(hMyDiary);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_SETENDOFFILE,MB_OK);
		goto ChangeEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	if (!bResult)
	{
		goto ChangeEnd;
	}
	hMyDiary = 0;
	bDiaryModified = TRUE;
	bDiaryError = TRUE;
	bCancelled = FALSE;
	bDeleteTemp = FALSE;

	// Now get the new pass phrase to protect the diary.
	//..................................................
	iDlgResult = DialogBox(hInst,TEXT("SETPASSWORDDIARY"),hMainWindow,
						  (DLGPROC)SetPasswordDiaryProc);
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto ChangeEnd;
	}
	if (iDlgResult == IDCANCEL)
	{
		goto ChangeEnd;
	}
	// We have our new password. Encrypt the DIARYEND structure again.
	//................................................................
	if (!hMyDiary)
	{
		hMyDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,0,
								 NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hMyDiary)
		{
			goto ChangeEnd;
		}
	}
	// Set the file pointer to the end of file.
	//.........................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_END);
	if (li.QuadPart == -1)
	{
		goto ChangeEnd;
	}
	// Encrypt the DIARYEND header with the password.
	//...............................................
	GetRandomBits((CFB_LENGTH*8),&DiaryEnd.cfb);
	EncipherSecretComponents((LPBYTE)&szJrlPassWord,(LPBYTE)&DiaryEnd.id,
							  lstrlen((LPCTSTR)&szJrlPassWord),sizeof(DIARYEND)-CFB_LENGTH);

	bResult = WriteMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryEnd,sizeof(DIARYEND),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto ChangeEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	if (!bResult)
	{
		goto ChangeEnd;
	}
	hMyDiary = 0;
	bDiaryError = FALSE;
	bDiaryModified = FALSE;
	
	ChangeEnd:

	ZeroMemory(&DiaryEnd,sizeof(DIARYEND));

	if (hMyDiary)
	{
		CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	}
	if (bDiaryModified && bDiaryError)
	{
		// We have to replace the diary with the copy.
		//............................................
		bResult = CopyFile((LPCTSTR)&szDiaryTemp,(LPCTSTR)&szMyDiary,FALSE);
		if (bResult)
		{
			WipeMyFile((LPTSTR)&szDiaryTemp,TRUE);
		}
	}
	else if (!bDiaryError && !bDiaryModified)
	{
		WipeMyFile((LPBYTE)&szDiaryTemp,TRUE);
	}
	else if (bDeleteTemp)
	{
		WipeMyFile((LPBYTE)&szDiaryTemp,TRUE);
	}
	// Display a final status mesage.
	//...............................
	if (!bCancelled)
	{
		if (!bDiaryError)
		{
			LoadString(hInst,IDS_JRLPWOK,(LPTSTR)&szBuffer2,sizeof(szBuffer2));
		}
		else
		{
			LoadString(hInst,IDS_JRLPWNOK,(LPTSTR)&szBuffer2,sizeof(szBuffer2));
		}
		StringCbPrintf((LPTSTR)&szBuffer1,sizeof(szBuffer1),(LPCTSTR)&szBuffer2,lpJrlName);

		MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)&szBuffer1,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for setting a new password for a diary.
//...........................................................
LRESULT CALLBACK SetPasswordDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	DWORD		dwLengthPP2;
	int			iResult;
	LPBYTE		lpDiaryName;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the pass phrases.
			//..........................................
			SendDlgItemMessage(hDlg,IDC_DIARYPP1,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PP2,EM_SETLIMITTEXT,(WPARAM) 255,0);
			ZeroMemory(&szPassWord1,sizeof(szPassWord1));
			ZeroMemory(&szPassWord2,sizeof(szPassWord2));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			lpDiaryName = PathFindFileName((LPCTSTR)&szMyDiary);
			SetDlgItemText(hDlg,IDC_DIARY,(LPCTSTR)lpDiaryName);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_DIARYPP1));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Now check out the passwords.
					//.............................
					GetDlgItemText(hDlg,IDC_DIARYPP1,(LPTSTR)&szTemp1,sizeof(szTemp1));
					GetDlgItemText(hDlg,IDC_PP2,(LPTSTR)&szTemp2,sizeof(szTemp2));

					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPCTSTR)&szTemp1);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szPassWord1[dwV] = szTemp1[dwV];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szPassWord2[dwV] = szTemp2[dwV];
							}
						}
					}

					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szPassWord1,-1,
										   (LPCTSTR)&szPassWord2,-1);
					if (iResult != CSTR_EQUAL ||
					   (iResult == CSTR_EQUAL && (dwLengthPP1 < 6 || dwLengthPP1 > 255)))
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_DIARYPPNOTEQ,
									   MB_ICONINFORMATION | MB_OK | MB_HELP,
									   MB_ICONINFORMATION,0);
						SetDlgItemText(hDlg,IDC_DIARYPP1,lpszNullString);
						SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						SetFocus(GetDlgItem(hDlg,IDC_DIARYPP1));
						break;
					}
					CopyMemory(&szJrlPassWord,&szPassWord1,sizeof(&szPassWord1));
					
					ZeroMemory(&szPassWord1,sizeof(szPassWord1));
					ZeroMemory(&szPassWord2,sizeof(szPassWord2));
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_PPTSCGTEXT:
				{
					VirtualKeyboard(hDlg,IDC_DIARYPP1,(LPBYTE)&szPassWord1,
									sizeof(szPassWord1));
					SetFocus(GetDlgItem(hDlg,IDC_DIARYPP1));
				}
				break;

				case IDC_PPTEXT2:
				{
					VirtualKeyboard(hDlg,IDC_PP2,(LPBYTE)&szPassWord2,
									sizeof(szPassWord2));
					SetFocus(GetDlgItem(hDlg,IDC_PP2));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_DIARYPP1,lpszNullString);
					SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
					ZeroMemory(&szPassWord1,sizeof(szPassWord1));
					ZeroMemory(&szPassWord2,sizeof(szPassWord2));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_PPTSCGCLEAR:
				{
					SetDlgItemText(hDlg,IDC_DIARYPP1,lpszNullString);
					SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
					ZeroMemory(&szPassWord1,sizeof(szPassWord1));
					ZeroMemory(&szPassWord2,sizeof(szPassWord2));
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNAME));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Get the names of the 12 months for the locale.
//...............................................
BOOL GetMonthNames()
{
	BOOL			bError = FALSE;
	int				iNameLength, i;

	LCTYPE			lct = LOCALE_SMONTHNAME1;

	for (i = 1; i < 13; i++)
	{
		iNameLength = GetLocaleInfo(LOCALE_USER_DEFAULT,lct,lpMonths[i],0);

		lpMonths[i] = AllocateMemory((DWORD)iNameLength);

		if (!lpMonths[i])
		{
			bError = TRUE;
			break;
		}
		GetLocaleInfo(LOCALE_USER_DEFAULT,lct,lpMonths[i],iNameLength);
		lct++;
	}
	return(bError);
}

// Deallocate the memory for the month names.
//...........................................
VOID DeallocateMonthNames()
{
	int			i;

	for (i = 1; i < 13; i++)
	{
		DeallocateMemory(lpMonths[i]);
	}
}

// CALLBACK procedure for the decrypt pke packet dialog box for a diary.
//......................................................................
LRESULT CALLBACK DecryptPkePacketDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			SetBoldFont(hDlg,IDC_MESSAGE,0);

			// Setup the name of the file to decipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szMyDiary));

			// Setup the name of the key owner.
			//.................................
			SetDlgItemTextFmt(hDlg,IDC_RECIPIENT,(LPCTSTR)lpMyKey->TempUserId);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Setup the secret key to use for the diary.
//...........................................
BOOL SetupDiaryKey(LPBYTE lpKeyId)
{
	BOOL			bError = TRUE;
	LARGE_INTEGER	li;
	DWORD			dwBytesRead;
	int				iResult;
	DWORD			dwCtb_Byte;
	BYTE			TempCTB;

	SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_TWO);
	li.QuadPart = SearchMyFileBinary(lpIndexFile2,lpKeyId,KEY_ID_SIZE,hIdxHandle2,0,
									 &KeyIdSearch);
	if (li.QuadPart == -1)
	{
		goto SetupEnd;
	}
	// No secret key.
	//...............
	if (li.QuadPart == 0)
	{
		SetLastError(IDS_NOSECRETKEYFORDIARY);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
		goto SetupEnd;
	}
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);
	if (!lpKeyBuffer2 || !lpKeyBuffer3)
	{
		goto SetupEnd;
	}
	// We had a match. Go and get the secret key.
	//...........................................
	dwIdxOffset2 = li.HighPart;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1 || dwBytesRead == 0)
	{
		goto SetupEnd;
	}

	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1 || dwBytesRead == 0)
	{
		goto SetupEnd;
	}
	// We have our secret key. Set up for signing and using n and e.
	// First get the user id.
	//..............................................................
	lpKeyBufferDup2 = lpKeyBuffer2;

	ZeroMemory(&TempUserId,sizeof(TempUserId));

	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup2
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup2,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				mov		ecx,eax
				mov		esi,edi
				mov		edi,offset TempUserId
				rep		movsb
			}
			break;
		}
	}
	iResult = SignSetup(lpKeyBuffer2,IDS_NODIARYPP,IDS_INVALIDDIARYPP);
	
	// If we had an error or did not decrypt the secret components, bail out.
	//.......................................................................
	if (iResult == -1 || iResult == 0)
	{
		goto SetupEnd;
	}
	// Copy the components of the secret key to our structure.
	//........................................................
	CopyMemory(lpMyKey->D_Temp,&D_Temp,MAX_MOD_SLOP);
	CopyMemory(lpMyKey->E_Temp,&E_Temp,MAX_MOD_SLOP);
	CopyMemory(lpMyKey->Modulus_N,&Modulus_N,MAX_MOD_SLOP);
	CopyMemory(lpMyKey->Prime_P,&Prime_P,MAX_PRIME_SLOP);
	CopyMemory(lpMyKey->Prime_Q,&Prime_Q,MAX_PRIME_SLOP);
	CopyMemory(lpMyKey->U_Temp,&U_Temp,MAX_MOD_SLOP);
	CopyMemory(lpMyKey->TempUserId,&TempUserId,sizeof(TempUserId));
	lpMyKey->dwN_Bits = dwN_Bits;
	lpMyKey->dwN_Bytes = dwN_Bytes;

	ClearAllVariables();
	ZeroMemory(&TempUserId,sizeof(TempUserId));

	ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
	DeallocateMemory(lpKeyBuffer2);
	lpKeyBuffer2 = 0;
	ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
	DeallocateMemory(lpKeyBuffer3);
	lpKeyBuffer3 = 0;

	bError = FALSE;

	SetupEnd:

	return(bError);
}

// Setup the random number generators for encrypting the diary or diary page.
//...........................................................................
VOID SetupDiaryRngs(DWORD dwModNBytes)
{
	LPBYTE			lpTempHeader;
	DWORD			dwSeedsNeededDup;
	DWORD			dwCheckSum;

	lpCsumOffset = (LPBYTE)&rphdr;
	lpSeedOffset = (LPBYTE)&rphdr;

	// Initial settings.
	//..................
	dwRngsUsed = RNGS_128;
	dwReproLength = KEY_128_LGTH;

	if (dwModNBytes < KEY_BITS_8)
	{
		dwRngsUsed = RNGS_4;
		dwReproLength = KEY_4_LGTH;
	}
	else if (dwModNBytes < KEY_BITS_16)
	{
		dwRngsUsed = RNGS_8;
		dwReproLength = KEY_8_LGTH;
	}
	else if (dwModNBytes < KEY_BITS_32)
	{
		dwRngsUsed = RNGS_16;
		dwReproLength = KEY_16_LGTH;
	}
	else if (dwModNBytes < KEY_BITS_64)
	{
		dwRngsUsed = RNGS_32;
		dwReproLength = KEY_32_LGTH;
	}
	else if (dwModNBytes < KEY_BITS_128)
	{
		dwRngsUsed = RNGS_64;
		dwReproLength = KEY_64_LGTH;
	}
	lpCsumOffset += (dwReproLength - SIZE_OF_CSUM);
	lpSeedOffset += (dwReproLength - SIZE_OF_CSUM - SIZE_OF_SEED);

	__asm
	{
		mov		eax,dwRngsUsed
		mov		RingMask,al
		dec		RingMask
		mov		ecx,SEEDS_IN_RNG
		mul		ecx
		mov		dwSeedsNeeded,eax
	}
	dwSeedsNeededDup = dwSeedsNeeded;
	lpTempHeader = (LPBYTE)&rphdr;
	StirTheBits();

	// Fill up the header with our randomly generated numbers.
	//........................................................
	while(dwSeedsNeededDup > 0)
	{
		while(TRUE)
		{
			GetRandomBits(32,&Seed);
			if (Seed >= 100000001)
			{
				break;
			}
		}
		__asm
		{
			mov		edi,lpTempHeader
			mov		eax,Seed
			stosd
			mov		lpTempHeader,edi
		}
		dwSeedsNeededDup--;
	}
	// Get a 5 bit random array shift factor between 17 and 24.
	//.........................................................
	while(TRUE)
	{
		GetRandomBits(5,&Seed);
		if (Seed >= 17 && Seed <= 24)
		{
			break;
		}
	}
	// Shift the random numbers in the factor array.
	//..............................................
	__asm
	{
		xor		ebx,ebx
		xor		edi,edi
		mov		ecx,dwRngsUsed
	L1:	push	ecx
		mov		ecx,Seed
		mov		eax,dword ptr rphdr[edi*4]
		shrd	eax,ebx,cl
		mov		dword ptr rphdr[edi*4],eax
		inc		edi
		pop		ecx
		dec		ecx
		jnz		L1
	}
	// Get a random initial seed for the random number generators.
	//............................................................
	while(TRUE)
	{
		GetRandomBits(32,&Seed);
		if (Seed >= 100000001)
		{
			break;
		}
	}

	__asm
	{
		mov		eax,Seed
		mov		edi,lpSeedOffset
		mov		dword ptr [edi],eax
	}

	dwCheckSum = CheckSum((LPBYTE)&rphdr,(dwReproLength - SIZE_OF_CSUM));

	__asm
	{
		mov		edi,lpCsumOffset
		mov		eax,dwCheckSum
		xchg	ah,al
		mov		word ptr [edi],ax
	}
	StirTheBits();
}

// Setup the arrays for use by the Rngs.
//......................................
VOID SetupDiaryArrays()
{
	// Setup the factor array first, followed by the tops
	// and seeds array.
	//...................................................
	__asm
	{
		mov		eax,dwRngsUsed
		mov		ecx,SIZE_OF_SEED
		mul		ecx
		mov		ecx,eax
		push	ecx
		push	ecx
		mov		esi,offset rphdr
		mov		edi,offset FactorArray
		rep		movsb
		pop		ecx
		mov		edi,offset TopsArray
		rep		movsb
		pop		ecx
		mov		edi,offset SeedsArray
		rep		movsb

		// Setup the first LastSeed value.
		//................................
		mov		al,byte ptr rphdr[12]
		and		al,RingMask
		mov		LastSeed,al

		// Setup the DbleNumber value.
		//............................
		mov		esi,lpSeedOffset
		mov		eax,dword ptr [esi-7]
		clc
		rcl		eax,1
		jnc		L1
		mov		eax,-1
	L1:	mov		DbleNumber,eax
	}
}

// Delete the old diary pages from the diary file.
//................................................
BOOL DeleteOldDiaryPages()
{
	TCHAR			szDiaryFile[MAX_PATH];
	HANDLE			hDiaryFile = 0;
	BOOL			bError = TRUE;
	BOOL			bResult;
	BOOL			dwBytes;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwBytesToRead;
	int				iCompareResult;
	LARGE_INTEGER	li;

	CopyMemory(&szDiaryFile,&szMyDiary,MAX_PATH);
	PathRemoveFileSpec((LPTSTR)&szDiaryFile);
	PathAddBackslash((LPTSTR)&szDiaryFile);
	StringCbCatEx((LPTSTR)&szDiaryFile,sizeof(szDiaryFile),(LPCTSTR)&szDiaryName,NULL,NULL,
				   dwStringSafeFlag);

	hDiaryFile = CreateMyFile((LPTSTR)&szDiaryFile,GENERIC_READ | GENERIC_WRITE,0,
								 NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hDiaryFile)
	{
		goto OldEnd;
	}
	// Position file pointer to point to first diary page.
	//....................................................
	li.QuadPart = sizeof(DIARYHDR);
	li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto OldEnd;
	}
	// Write the header id for the new file.
	//......................................
	bResult = WriteMyFile((LPTSTR)&szDiaryFile,hDiaryFile,&szDiaryId,sizeof(DIARYHDR),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto OldEnd;
	}
	// Process the rest of the file in a loop.
	//........................................
	while(TRUE)
	{
		EmptyTheMessageQue();

		bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,&DiaryPage,sizeof(DIARYPAGE),
							  &dwBytesRead,NULL);
		if (!bResult)
		{
			goto OldEnd;
		}
		if (dwBytesRead == 0)
		{
			break;
		}
		// Do we have a valid diary page.
		//...............................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&DiaryPage.id,
									   4,(LPCTSTR)&szDiaryId,4);
		if (iCompareResult != CSTR_EQUAL)
		{
			SetLastError(IDS_INVALIDDIARYPAGE);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_READ,MB_OK);
			goto OldEnd;
		}
		// If this has been modified, we do not keep it. Just position the
		// file pointer to the next record.
		//................................................................
		if (DiaryPage.bEdited)
		{
			// Get the current file position.
			//...............................
			li.QuadPart = 0;
			li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,
										    FILE_CURRENT);
			if (li.QuadPart == -1)
			{
				goto OldEnd;
			}
			li.QuadPart += DiaryPage.dwDataLength;
			li.QuadPart = SetMyFilePointer((LPTSTR)&szMyDiary,hMyDiary,li.QuadPart,
										    FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				goto OldEnd;
			}
		}
		else
		{
			// Write the header for the page first.
			//.....................................
			bResult = WriteMyFile((LPTSTR)&szDiaryFile,hDiaryFile,&DiaryPage,
								  sizeof(DIARYPAGE),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto OldEnd;
			}
			// We copy this page to the new file.
			//...................................
			dwBytes = DiaryPage.dwDataLength;

			while(dwBytes != 0)
			{
				if (dwBytes > ENC_BUFFER_SIZE)
				{
					dwBytesToRead = ENC_BUFFER_SIZE;
					dwBytes -= ENC_BUFFER_SIZE;
				}
				else
				{
					dwBytesToRead = dwBytes;
					dwBytes = 0;
				}
				bResult = ReadMyFile((LPTSTR)&szMyDiary,hMyDiary,lpKeyBuffer1,dwBytesToRead,
									  &dwBytesRead,NULL);
				if (!bResult)
				{
					goto OldEnd;
				}
				bResult = WriteMyFile((LPTSTR)&szDiaryFile,hDiaryFile,lpKeyBuffer1,
									  dwBytesRead,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto OldEnd;
				}
			}
		}
	}
	// Close the new diary file.
	//..........................
	bResult = CloseMyHandle((LPTSTR)&szDiaryFile,hDiaryFile);
	if (!bResult)
	{
		goto OldEnd;
	}
	hDiaryFile = 0;

	// Delete the original diary file.
	//................................
	bResult = CloseMyHandle((LPTSTR)&szMyDiary,hMyDiary);
	if (!bResult)
	{
		goto OldEnd;
	}
	bError = WipeMyFile((LPBYTE)&szMyDiary,TRUE);
	if (bError)
	{
		goto OldEnd;
	}
	// Copy the new file to the old one.
	//..................................
	bResult = CopyFile((LPCTSTR)&szDiaryFile,(LPCTSTR)&szMyDiary,FALSE);
	if (!bResult)
	{
		goto OldEnd;
	}
	// Open up the new diary file.
	//............................
	hMyDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,0,
							 NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hMyDiary)
	{
		goto OldEnd;
	}
	bError = FALSE;

	OldEnd:

	if (hDiaryFile)
	{
		CloseMyHandle((LPTSTR)&szDiaryFile,hDiaryFile);
	}
	WipeMyFile((LPBYTE)&szDiaryFile,TRUE);

	return(bError);
}

// Encipher the components of the secret key in memory.
//.....................................................
BOOL EncComponents()
{
	DWORD		dwSize;

	dwSize = sizeof(SECRETKEYDATA);

	if (!lpEncSecKey)
	{
		lpEncSecKey = AllocateMemory(sizeof(SECRETKEYDATA));

		if (!lpEncSecKey)
		{
			goto EncEnd;
		}
	}
	GetRandomBits(8 * sizeof(SECRETKEYDATA),lpEncSecKey);

	__asm
	{
		mov		esi,lpEncSecKey
		mov		edi,lpMyKey
		mov		ecx,dwSize
	L1:	lodsb
		xor		byte ptr [edi],al
		not		byte ptr [edi]
		inc		edi
		dec		ecx
		jnz		L1
	}

	EncEnd:
	
	return((BOOL)lpEncSecKey);
}

// Decipher the components of the secret key in memory.
//.....................................................
VOID DecComponents()
{
	DWORD		dwSize;

	dwSize = sizeof(SECRETKEYDATA);

	__asm
	{
		mov		esi,lpEncSecKey
		mov		edi,lpMyKey
		mov		ecx,dwSize
	L1:	lodsb
		xor		byte ptr [edi],al
		not		byte ptr [edi]
		inc		edi
		dec		ecx
		jnz		L1
	}
}

